<?php
$color = $settings->color_field;

// Add '#' if not present
if ($color && strpos($color, '#') !== 0) {
    $color = '#' . $color;
}
?>

<div class="fl-new-module">

    <h2>Sample Text Output</h2>
    <p><?php echo esc_html($settings->text_field); ?></p>

    <h2>Textarea Output</h2>
    <p><?php echo nl2br(esc_html($settings->textarea_field)); ?></p>

    <h2>Code Field Output</h2>
    <pre><code><?php echo esc_html($settings->code_field); ?></code></pre>

    <h2>Editor Output</h2>
    <div><?php echo $settings->editor_field; ?></div>

    <h2>Color Field Output</h2>
    <div style="color: <?php echo esc_attr($color); ?>;">
        <p>This text will use the color you picked.</p>
    </div>

    <h2>Unit Field Output</h2>
    <p><?php echo esc_html($settings->number_field); ?></p>

    <h2>Select Output</h2>
    <p><?php echo esc_html($settings->select_field); ?></p>

    <h2>Multi-Select Output</h2>
    <?php if (!empty($settings->multiselect_field) && is_array($settings->multiselect_field)) : ?>
        <ul>
            <?php foreach ($settings->multiselect_field as $item): ?>
                <li><?php echo esc_html($item); ?></li>
            <?php endforeach; ?>
        </ul>
    <?php else: ?>
        <p>No items selected.</p>
    <?php endif; ?>

    <h2>Checkbox Output</h2>
    <p><?php echo $settings->checkbox_field ? 'Checked' : 'Not Checked'; ?></p>

    <h2>Checkbox Group Output</h2>
    <?php if (!empty($settings->checkbox_group_field) && is_array($settings->checkbox_group_field)) : ?>
        <ul>
            <?php foreach ($settings->checkbox_group_field as $val): ?>
                <li><?php echo esc_html($val); ?></li>
            <?php endforeach; ?>
        </ul>
    <?php else: ?>
        <p>No options selected.</p>
    <?php endif; ?>

    <h2>Radio Output</h2>
    <p><?php echo esc_html($settings->radio_field); ?></p>

    <h2>Single Photo</h2>
    <?php if (!empty($settings->photo_field)) : ?>
        <img src="<?php echo esc_url($settings->photo_field); ?>" alt="Uploaded Photo" style="max-width:200px;" />
    <?php endif; ?>

    <h2>Multiple Photos</h2>
    <?php if (!empty($settings->multiple_photos_field) && is_array($settings->multiple_photos_field)) : ?>
        <?php foreach ($settings->multiple_photos_field as $img): ?>
            <img src="<?php echo esc_url($img); ?>" alt="Gallery Image" style="max-width:100px;margin-right:10px;" />
        <?php endforeach; ?>
    <?php else: ?>
        <p>No images added.</p>
    <?php endif; ?>

    <h2>Media (Video)</h2>
    <?php if (!empty($settings->media_field)) : ?>
        <video src="<?php echo esc_url($settings->media_field); ?>" controls width="300"></video>
    <?php endif; ?>

    <h2>Formatted Fields</h2>
    <?php if (!empty($settings->formattable_field) && is_array($settings->formattable_field)) : ?>
        <?php foreach ($settings->formattable_field as $row): ?>
            <h3><?php echo esc_html($row['heading'] ?? ''); ?></h3>
            <p><?php echo esc_html($row['description'] ?? ''); ?></p>
        <?php endforeach; ?>
    <?php else: ?>
        <p>No formatted entries.</p>
    <?php endif; ?>

    <h2>Icon</h2>
    <?php if (!empty($settings->icon_field)) : ?>
        <i class="<?php echo esc_attr($settings->icon_field); ?>" style="font-size: 24px;"></i>
    <?php endif; ?>

</div>
