<?php
$settings = $module->settings;
$layout   = isset($settings->layout_type) ? $settings->layout_type : 'carousel';
$post_count = !empty($settings->posts_count) ? intval($settings->posts_count) : 6;

$args = array(
	'post_type'      => 'post',
	'posts_per_page' => $post_count,
);

$loop = new WP_Query($args);

if ($loop->have_posts()):

	$module_slug = sanitize_html_class( $module->slug ); // usually same as folder name, like az-post-grid
	
?>

<link rel="stylesheet" href="<?php echo esc_url( $module->url . 'css/az-post-slider.css' ); ?>" />

<section  id="module-<?php echo esc_attr( $module->slug ); ?>" class="<?php echo esc_attr( $module->slug ); ?>" data-module="<?php echo esc_attr( $module_slug ); ?>">


<div class="az-post-grid-wrapper <?php echo esc_attr($layout); ?>">
	<?php if ($layout === 'carousel'): ?>
		<div class="swiper az-swiper">
			<div class="swiper-wrapper">
				<?php while ($loop->have_posts()): $loop->the_post(); ?>
					<div class="swiper-slide">
						<h2><?php the_title(); ?></h2>
						<p><?php echo get_the_excerpt(); ?></p>
					</div>
				<?php endwhile; ?>
			</div>
			<div class="swiper-button-prev">
	<?php if (!empty($settings->prev_icon)) : ?>
		<i class="<?php echo esc_attr($settings->prev_icon); ?>"></i>
	<?php else : ?>
		Prev
	<?php endif; ?>
</div>
<div class="swiper-button-next">
	<?php if (!empty($settings->next_icon)) : ?>
		<i class="<?php echo esc_attr($settings->next_icon); ?>"></i>
	<?php else : ?>
		Next
	<?php endif; ?>
</div>

		</div>

		<script>
			document.addEventListener('DOMContentLoaded', function () {
				new Swiper('.az-swiper', {
					slidesPerView: 1,
					loop: <?= $settings->loop === 'true' ? 'true' : 'false'; ?>,
					autoplay: <?php echo $settings->autoplay === '1' ? '{ delay: 3000, disableOnInteraction: false }' : 'false'; ?>,
					spaceBetween: 20,
					navigation: {
						nextEl: '.swiper-button-next',
						prevEl: '.swiper-button-prev',
					},
					breakpoints: {
						768: {
							slidesPerView: 2
						},
						1024: {
							slidesPerView: 3
						}
					}
				});
			});
		</script>

	<?php else: ?>
		<div class="az-grid-layout">
			<?php while ($loop->have_posts()): $loop->the_post(); ?>
				<div class="az-grid-item">
					<h2><?php the_title(); ?></h2>
					<p><?php echo get_the_excerpt(); ?></p>
				</div>
			<?php endwhile; ?>
		</div>
	<?php endif; ?>
</div>


</section>


<?php endif; wp_reset_postdata(); ?>
