<?php

/**
 * @class FLAZPostSliderModule
 */
class FLAZPostSliderModule extends FLBuilderModule {

	public function __construct() {
		parent::__construct([
			'name'        => __('AZ Post Slider', 'fl-builder'),
			'description' => __('A customizable carousel or Slider post layout.', 'fl-builder'),
			'category'    => __('Custom Modules', 'fl-builder'),
			'dir'         => plugin_dir_path(__FILE__),
			'url'         => plugin_dir_url(__FILE__),
			'editor_export' => true,
			'enabled'       => true,
			'partial_refresh' => true,
		]);

		// Add frontend CSS
		$this->add_css('az-post-slider');
		$this->add_js('az-post-slider');
	}

	public function enqueue_scripts() {
		// Swiper JS
		wp_enqueue_script(
			'swiper-js',
			'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js',
			array(),
			'10.0.0',
			true
		);

		// Swiper CSS
		wp_enqueue_style(
			'swiper-css',
			'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css',
			array(),
			'10.0.0'
		);
		
	}
}

// Register the module
FLBuilder::register_module('FLAZPostSliderModule', [
	'general' => [
		'title' => __('General', 'fl-builder'),
		'sections' => [
			'settings' => [
				'title' => __('Settings', 'fl-builder'),
				'fields' => [
					'layout_type' => [
						'type'    => 'select',
						'label'   => __('Layout Type', 'fl-builder'),
						'default' => 'carousel',
						'options' => [
							'carousel' => __('Carousel', 'fl-builder'),
							'Slider'     => __('Slider', 'fl-builder'),
						],
					],
					'posts_count' => [
						'type'    => 'text',
						'label'   => __('Number of Posts', 'fl-builder'),
						'default' => '6',
					],
					'autoplay' => [
						'type'    => 'select',
						'label'   => __('Autoplay', 'fl-builder'),
						'default' => '1',
						'options' => [
							'1' => __('Yes', 'fl-builder'),
							'0' => __('No', 'fl-builder'),
						],
					],
					'loop' => [
					'type'    => 'select',
					'label'   => __('Loop Slides', 'fl-builder'),
					'default' => 'true',
					'options' => [
						'true'  => __('Yes', 'fl-builder'),
						'false' => __('No', 'fl-builder'),
					],
					],
					'prev_icon' => [
						'type'  => 'icon',
						'label' => __('Previous Icon', 'fl-builder'),
					],
					'next_icon' => [
						'type'  => 'icon',
						'label' => __('Next Icon', 'fl-builder'),
					],
					'Slider_pagination_type' => [
					'type'    => 'select',
					'label'   => __('Slider Pagination Type', 'fl-builder'),
					'default' => 'ajax',
					'options' => [
						'ajax'      => __('Numbered (AJAX)', 'fl-builder'),
						'load_more' => __('Load More Button', 'fl-builder'),
					],
				],





				],
			],
		],
	],
]);
