<?php
$settings        = $module->settings;
$layout          = isset($settings->layout_type) ? $settings->layout_type : 'carousel';
$post_count      = !empty($settings->posts_count) ? intval($settings->posts_count) : 6;
$module_id = 'mod_' . $module->node; // contoh output: mod_62fc81915b733

$paged_key = 'az_paged_' . $module_id;
$paged = isset($_GET[$paged_key]) ? intval($_GET[$paged_key]) : 1;
$pagination_type = !empty($settings->pagination_type) ? $settings->pagination_type : 'numbers';
$post_type       = !empty($settings->content_type) ? $settings->content_type : 'post';
$taxonomy_filter = !empty($settings->category_filter) ? $settings->category_filter : '';

$args = array(
    'post_type'      => $post_type,
    'posts_per_page' => $post_count,
    'paged'          => $paged,
);

// Tambah order by setting di sini
switch ($settings->order_by) {
    case 'date_asc':
        $args['orderby'] = 'date';
        $args['order'] = 'ASC';
        break;
    case 'title_asc':
        $args['orderby'] = 'title';
        $args['order'] = 'ASC';
        break;
    case 'title_desc':
        $args['orderby'] = 'title';
        $args['order'] = 'DESC';
        break;
    case 'rand':
        $args['orderby'] = 'rand';
        break;
    case 'date_desc':
    default:
        $args['orderby'] = 'date';
        $args['order'] = 'DESC';
        break;
}

if ( $settings->post_type === 'product' && !empty($settings->product_category) ) {
    $args['tax_query'][] = [
        'taxonomy' => 'product_cat',
        'field'    => 'term_id',
        'terms'    => $settings->product_category,
    ];
}

if (!empty($taxonomy_filter)) {
    $taxonomy = ($post_type === 'product') ? 'product_cat' : 'category';
    $args['tax_query'][] = array(
        'taxonomy' => $taxonomy,
        'field'    => 'slug',
        'terms'    => explode(',', $taxonomy_filter),
    );
}

if ($post_type === 'product') {
    if (!empty($settings->only_featured) && $settings->only_featured === 'yes') {
        $args['tax_query'][] = array(
            'taxonomy' => 'product_visibility',
            'field'    => 'name',
            'terms'    => array('featured'),
            'operator' => 'IN',
        );
    }

    if (!empty($settings->only_sale) && $settings->only_sale === 'yes') {
        $args['post__in'] = wc_get_product_ids_on_sale();
    }
}

$loop = new WP_Query($args);
$module_slug = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-post-grid.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<div class="az-post-grid-wrapper <?php echo esc_attr($layout); ?>">

<?php if ($layout === 'carousel'): ?>
    <div class="swiper az-swiper">
        <div class="swiper-wrapper">
            <?php while ($loop->have_posts()): $loop->the_post(); global $product; ?>
                <div class="swiper-slide">
                    <?php if (has_post_thumbnail() && $settings->show_product_thumbnail === 'yes'): ?>
					<a href="<?php the_permalink(); ?>">
                        <?php if ($post_type === 'product') : ?>
                            <?php
                            $product = wc_get_product(get_the_ID());
                            $gallery_ids = $product->get_gallery_image_ids();
                            $main_img = get_the_post_thumbnail(get_the_ID(), 'woocommerce_thumbnail', ['class' => 'main-image']);
                            $hover_img = '';

                            if (!empty($gallery_ids)) {
                                $hover_img_url = wp_get_attachment_image_url($gallery_ids[0], 'woocommerce_thumbnail');
                                $hover_img = '<img src="' . esc_url($hover_img_url) . '" class="hover-image" />';
                            }

                            echo '<div class="product-thumb-hover">';
                            echo $main_img;
                            echo $hover_img;
                            echo '</div>';
                            ?>
                        <?php else: ?>
                            <div class="post-thumb">
                                <?php the_post_thumbnail('medium'); ?>
                            </div>
                        <?php endif; ?>
						</a>
                    <?php endif; ?>

                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                    <?php if ( $settings->show_description === 'yes' ) : ?>
                        <p><?php echo wp_trim_words(get_the_excerpt(), $settings->excerpt_length); ?></p>
                    <?php endif; ?>

                    <?php if ($post_type === 'product'): ?>
                        <?php if ($settings->show_product_price === 'yes' && function_exists('wc_get_product')): ?>
                            <div class="product-price"><?php echo $product->get_price_html(); ?></div>
                        <?php endif; ?>

                        <?php if ($settings->show_add_to_cart === 'yes'): ?>
                            <a href="?add-to-cart=<?php echo esc_attr($product->get_id()); ?>"
                               class="button add_to_cart_button ajax_add_to_cart"
                               data-product_id="<?php echo esc_attr($product->get_id()); ?>">
                                <?php esc_html_e('Add to cart', 'woocommerce'); ?>
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php endwhile; ?>
        </div>
        <div class="swiper-button-prev"><?php echo !empty($settings->prev_icon) ? '<i class="' . esc_attr($settings->prev_icon) . '"></i>' : 'Prev'; ?></div>
        <div class="swiper-button-next"><?php echo !empty($settings->next_icon) ? '<i class="' . esc_attr($settings->next_icon) . '"></i>' : 'Next'; ?></div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function () {
        new Swiper('.az-swiper', {
            slidesPerView: 1,
            loop: <?php echo $settings->loop === 'true' ? 'true' : 'false'; ?>,
            autoplay: <?php echo $settings->autoplay === '1' ? '{ delay: 3000, disableOnInteraction: false }' : 'false'; ?>,
            spaceBetween: 20,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                768: { slidesPerView: 2 },
                1024: { slidesPerView: 3 }
            }
        });
    });
    </script>

<?php else: ?>
    <div class="az-grid-layout">
        <?php while ($loop->have_posts()): $loop->the_post(); global $product; ?>
		
            <div class="az-grid-item">
				<a href="<?php the_permalink(); ?>">
                <?php if (has_post_thumbnail() && $settings->show_product_thumbnail === 'yes'): ?>
                    <?php if ($post_type === 'product') : ?>
                        <?php
                        $product = wc_get_product(get_the_ID());
                        $gallery_ids = $product->get_gallery_image_ids();
                        $main_img = get_the_post_thumbnail(get_the_ID(), 'woocommerce_thumbnail', ['class' => 'main-image']);
                        $hover_img = '';

                        if (!empty($gallery_ids)) {
                            $hover_img_url = wp_get_attachment_image_url($gallery_ids[0], 'woocommerce_thumbnail');
                            $hover_img = '<img src="' . esc_url($hover_img_url) . '" class="hover-image" />';
                        }

                        echo '<div class="product-thumb-hover">';
                        echo $main_img;
                        echo $hover_img;
                        echo '</div>';
                        ?>
                    <?php else: ?>
                        <div class="post-thumb">
							<a href="<?php the_permalink(); ?>">
                            <?php the_post_thumbnail('full'); ?>
							</a>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>

                <?php if ( $settings->show_description === 'yes' ) : ?>
                    <p><?php echo wp_trim_words(get_the_excerpt(), $settings->excerpt_length); ?></p>
                <?php endif; ?>

                <?php if ($post_type === 'product'): ?>
                    <?php if ($settings->show_product_price === 'yes' && function_exists('wc_get_product')): ?>
                        <div class="product-price"><?php echo $product->get_price_html(); ?></div>
                    <?php endif; ?>

                    <?php if ($settings->show_add_to_cart === 'yes'): ?>
                        <a href="?add-to-cart=<?php echo esc_attr($product->get_id()); ?>"
                           class="button add_to_cart_button ajax_add_to_cart"
                           data-product_id="<?php echo esc_attr($product->get_id()); ?>">
                            <?php esc_html_e('Add to cart', 'woocommerce'); ?>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
					</a>
            </div>
		
        <?php endwhile; ?>
    </div>

    <?php if ($pagination_type === 'numbers'): ?>
        <div class="az-pagination-numbers">
            <?php
            echo paginate_links([
                'total'   => $loop->max_num_pages,
                'current' => $paged,
                'format'  => '?' . $paged_key . '=%#%',
                'prev_text' => __('« Prev'),
                'next_text' => __('Next »'),
            ]);
            ?>
        </div>
    <?php elseif ($pagination_type === 'load_more' && $loop->max_num_pages > 1): ?>
        <div class="az-load-more-wrap">
            <button id="az-load-more" data-page="1" data-max="<?php echo esc_attr($loop->max_num_pages); ?>">
                <?php echo !empty($settings->load_more_text) ? esc_html($settings->load_more_text) : 'Load More'; ?>
            </button>
        </div>

        <script>
        document.addEventListener('DOMContentLoaded', function () {
            const loadMoreBtn = document.getElementById('az-load-more');
            const container = document.querySelector('.az-grid-layout');

            loadMoreBtn.addEventListener('click', function () {
                let page = parseInt(this.dataset.page) + 1;
                const max = parseInt(this.dataset.max);
                const button = this;

                fetch('<?php echo site_url(); ?>/wp-admin/admin-ajax.php?action=az_load_more_posts&page=' + page)
                    .then(res => res.text())
                    .then(html => {
                        container.insertAdjacentHTML('beforeend', html);
                        this.dataset.page = page;
                        if (page >= max) button.remove();
                    });
            });
        });
        </script>
    <?php endif; ?>
<?php endif; ?>
</div>

</section>

<?php wp_reset_postdata(); ?>
