<?php
/**
 * @class FLAZPostGridModule
 */
class FLAZPostGridModule extends FLBuilderModule {

    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Post Grid', 'fl-builder'),
            'description'     => __('A customizable carousel or grid post layout.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'partial_refresh' => true,
        ]);

        // Add frontend CSS and JS
        $this->add_css('az-post-grid');
        $this->add_js('az-post-grid');
    }

    public function enqueue_scripts() {
        // Swiper JS
        wp_enqueue_script(
            'swiper-js',
            'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js',
            array(),
            '10.0.0',
            true
        );

        // Swiper CSS
        wp_enqueue_style(
            'swiper-css',
            'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css',
            array(),
            '10.0.0'
        );
    }
}

// Helper function to get WooCommerce product categories
function az_get_product_categories() {
    if (!class_exists('WooCommerce')) return [];
    $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
    $options = [];
    foreach ($terms as $term) {
        $options[$term->term_id] = $term->name;
    }
    return $options;
}

// Register the module with fields
FLBuilder::register_module('FLAZPostGridModule', [
    'general' => [
        'title' => __('General', 'fl-builder'),
        'sections' => [
            'settings' => [
                'title' => __('Settings', 'fl-builder'),
                'fields' => [
                    'layout_type' => [
                        'type'    => 'select',
                        'label'   => __('Layout Type', 'fl-builder'),
                        'default' => 'carousel',
                        'options' => [
                            'carousel' => __('Carousel', 'fl-builder'),
                            'grid'     => __('Grid', 'fl-builder'),
                        ],
                    ],
                    'posts_count' => [
                        'type'    => 'text',
                        'label'   => __('Number of Posts', 'fl-builder'),
                        'default' => '6',
                    ],
                    'autoplay' => [
                        'type'    => 'select',
                        'label'   => __('Autoplay', 'fl-builder'),
                        'default' => '1',
                        'options' => [
                            '1' => __('Yes', 'fl-builder'),
                            '0' => __('No', 'fl-builder'),
                        ],
                    ],
                    'loop' => [
                        'type'    => 'select',
                        'label'   => __('Loop Slides', 'fl-builder'),
                        'default' => 'true',
                        'options' => [
                            'true'  => __('Yes', 'fl-builder'),
                            'false' => __('No', 'fl-builder'),
                        ],
                    ],
                    'prev_icon' => [
                        'type'  => 'icon',
                        'label' => __('Previous Icon', 'fl-builder'),
                    ],
                    'next_icon' => [
                        'type'  => 'icon',
                        'label' => __('Next Icon', 'fl-builder'),
                    ],
                    'pagination_type' => [
                        'type'    => 'select',
                        'label'   => __('Grid Pagination Type', 'fl-builder'),
                        'default' => 'numbers',
                        'options' => [
                            'numbers'   => __('Numbered (AJAX)', 'fl-builder'),
                            'load_more' => __('Load More Button', 'fl-builder'),
                        ],
                    ],
                    'load_more_text' => [
                        'type'    => 'text',
                        'label'   => __('Load More Button Text', 'fl-builder'),
                        'default' => 'Load More',
                    ],
                ],
            ],


            'content_filtering' => [
                'title' => __('Content Filtering', 'fl-builder'),
                'fields' => [
                    'post_type' => [
                        'type'    => 'select',
                        'label'   => __('Post Type', 'fl-builder'),
                        'default' => 'post',
                        'options' => [
                            'post'    => __('Post', 'fl-builder'),
                            'page'    => __('Page', 'fl-builder'),
                            'product' => __('Product', 'fl-builder'),
                            'custom'  => __('Custom Post Type', 'fl-builder'),
                        ],
                    ],
                    'product_category' => [
                        'type'        => 'select',
                        'label'       => __('Product Category', 'fl-builder'),
                        'options'     => az_get_product_categories(),
                        'placeholder' => __('Select a category', 'fl-builder'),
                        'help'        => __('This only works if post type is WooCommerce product.', 'fl-builder'),
                    ],
                    'content_type' => [
                        'type'    => 'select',
                        'label'   => __('Content Type', 'fl-builder'),
                        'default' => 'post',
                        'options' => [
                            'post'    => __('Post', 'fl-builder'),
                            'product' => __('WooCommerce Product', 'fl-builder'),
                        ],
                    ],
                    'taxonomy' => [
                        'type'        => 'text',
                        'label'       => __('Taxonomy (e.g., category, product_cat)', 'fl-builder'),
                        'placeholder' => 'category',
                        'description' => __('Enter taxonomy name to filter by category/term.', 'fl-builder'),
                    ],
                    'term_ids' => [
                        'type'        => 'text',
                        'label'       => __('Term IDs (comma-separated)', 'fl-builder'),
                        'placeholder' => '1, 2, 3',
                        'description' => __('Enter term IDs to filter specific categories or tags.', 'fl-builder'),
                    ],
                    'only_featured' => [
                        'type'    => 'select',
                        'label'   => __('Only Featured Products?', 'fl-builder'),
                        'default' => 'no',
                        'options' => [
                            'no'  => __('No', 'fl-builder'),
                            'yes' => __('Yes', 'fl-builder'),
                        ],
                        'help' => __('Only works for WooCommerce products.', 'fl-builder'),
                    ],
                    'only_sale' => [
                        'type'    => 'select',
                        'label'   => __('Only Sale Products?', 'fl-builder'),
                        'default' => 'no',
                        'options' => [
                            'no'  => __('No', 'fl-builder'),
                            'yes' => __('Yes', 'fl-builder'),
                        ],
                        'help' => __('Only works for WooCommerce products.', 'fl-builder'),
                    ],
                    'show_product_thumbnail' => [
                        'type'    => 'select',
                        'label'   => __('Show Product Thumbnail', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                    ],
                    'show_product_price' => [
                        'type'    => 'select',
                        'label'   => __('Show Product Price', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                    ],
                    'show_add_to_cart' => [
                        'type'    => 'select',
                        'label'   => __('Show Add to Cart Button', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                    ],
                    'show_description' => [
                        'type'    => 'select',
                        'label'   => __('Show Description', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                    ],
								'order_by' => [
    'type'    => 'select',
    'label'   => __('Order By', 'fl-builder'),
    'default' => 'date_desc',
    'options' => [
        'date_desc'   => __('Date (Newest)', 'fl-builder'),
        'date_asc'    => __('Date (Oldest)', 'fl-builder'),
        'title_asc'   => __('Title A → Z', 'fl-builder'),
        'title_desc'  => __('Title Z → A', 'fl-builder'),
        'rand'        => __('Random', 'fl-builder'),
    ],
],
                    'excerpt_length' => [
                        'type'    => 'text',
                        'label'   => __('Excerpt Word Limit', 'fl-builder'),
                        'default' => '20',
                        'description' => __('Number of words to show in post/product description.', 'fl-builder')
                    ]
                ],
            ],
        ],
    ],
]);

// AJAX Handler for Load More
add_action('wp_ajax_az_load_more_posts', 'az_load_more_posts_callback');
add_action('wp_ajax_nopriv_az_load_more_posts', 'az_load_more_posts_callback');

function az_load_more_posts_callback() {
    $paged = isset($_GET['page']) ? intval($_GET['page']) : 1;

    $args = [
        'post_type'      => 'post',
        'posts_per_page' => 6,
        'paged'          => $paged,
    ];

    $query = new WP_Query($args);

    if ($query->have_posts()) :
        while ($query->have_posts()) : $query->the_post(); ?>
            <div class="az-grid-item">
                <h2><?php the_title(); ?></h2>
                <p><?php echo wp_trim_words(get_the_excerpt(), 20); ?></p>
            </div>
        <?php endwhile;
    endif;

    wp_reset_postdata();
    wp_die();
}
