document.addEventListener("DOMContentLoaded", function () {
    const animatedEls = document.querySelectorAll('.fl-animation:not(.no-repeat-anim)');
  
    const observer = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        const el = entry.target;
  
        if (entry.isIntersecting) {
          el.style.animation = 'none';
          el.offsetHeight; // force reflow
          el.style.animation = null;
  
          if (!el.classList.contains('fl-animated')) {
            el.classList.add('fl-animated');
          }
        } else {
          el.classList.remove('fl-animated');
        }
      });
    }, {
      threshold: 0.3
    });
  
    animatedEls.forEach((el) => {
      observer.observe(el);
    });
  });
  