<?php

// Defines
define( 'FL_CHILD_THEME_DIR', get_stylesheet_directory() );
define( 'FL_CHILD_THEME_URL', get_stylesheet_directory_uri() );

// Classes
require_once 'classes/class-fl-child-theme.php';

// Actions
add_action( 'wp_enqueue_scripts', 'FLChildTheme::enqueue_scripts', 10 );


//
// ─── MEDIA ATTACHMENT CUSTOM FIELD ──────────────────────────────────────────────
//

add_filter('attachment_fields_to_edit', 'add_media_category_field', 10, 2);
function add_media_category_field($form_fields, $post) {
    $value = get_post_meta($post->ID, 'category', true);
    $form_fields['category'] = [
        'label' => 'Category',
        'input' => 'text',
        'value' => $value,
        'helps' => 'Used for gallery filtering (e.g., car, house)',
    ];
    return $form_fields;
}

add_filter('attachment_fields_to_save', 'save_media_category_field', 10, 2);
function save_media_category_field($post, $attachment) {
    if (isset($attachment['category'])) {
        update_post_meta($post['ID'], 'category', sanitize_text_field($attachment['category']));
    }
    return $post;
}

// functions.php
function az_current_year_shortcode() {
    return date('Y');
}
add_shortcode('current_year', 'az_current_year_shortcode');


// Animation Repeat
function repeat_beaver_animation() {
    wp_enqueue_script(
        'repeat-anim',
        get_stylesheet_directory_uri() . '/js/repeat-anim.js',
        [], // Dependencies (e.g., array('jquery') if needed)
        null, // Version (null means no versioning)
        true // Load in footer
    );
}
add_action('wp_enqueue_scripts', 'repeat_beaver_animation');


// Enqueue additional custom JS (e.g., slide cart)
wp_enqueue_script('slide-cart', get_stylesheet_directory_uri() . '/js/custom.js', [], null, true);


// Force CSS Refresh (Bypass Caching with Versioning)
function my_child_theme_enqueue_styles() {
    wp_enqueue_style('parent-style', get_template_directory_uri() . '/style.css');
    wp_enqueue_style('child-style', get_stylesheet_directory_uri() . '/style.css', array('parent-style'), time());

}
add_action('wp_enqueue_scripts', 'my_child_theme_enqueue_styles');









