<?php if ( ! defined( 'ABSPATH' ) ) exit;

final class NF_Admin_Menus_Dashboard extends NF_Abstracts_Submenu
{
    public $parent_slug = 'ninja-forms';

    public $page_title = 'Dashboard';

    public $menu_slug = 'ninja-forms';

    public $position = 1;

    public function __construct()
    {
        parent::__construct();

        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_dashboard_script' ) );

        $opted_out = !has_filter( 'ninja_forms_settings_licenses_addons' ) && ( ! (bool) get_option( 'ninja_forms_allow_tracking' ) || (bool) get_option( 'ninja_forms_do_not_allow_tracking' ) );
        if(!$opted_out) { 
            add_action( 'admin_enqueue_scripts', [$this, 'enqueue_telemetry_script'] );
        }
    }

    public function get_page_title()
    {
        if( isset( $_GET[ 'form_id' ] ) ) {
            return esc_html__( 'Form Builder', 'ninja-forms' );
        }
        return esc_html__( 'Dashboard', 'ninja-forms' );
    }

    public function get_capability()
    {
        return apply_filters( 'ninja_forms_admin_all_forms_capabilities', $this->capability );
    }

    public function display()
    {
        // This section intentionally left blank.
    }

    /**
     * Enqueue dashboard page elements
     */
    public function enqueue_dashboard_script($page) {
        // let's check and make sure we're on the dashboard page.
        if( isset( $page ) && $page === "toplevel_page_ninja-forms" && ! isset( $_REQUEST['form_id'] ) ) {
            global $wp_version;
            //Enqueue Dashboard element for dashboard
            if( $wp_version >= "5.4" ){
                //Get Dependencies and Version from build asset.php generated by wp-scripts
                $dashboard_asset_php = [
                    "dependencies" => ['jquery'],
                    "version"   => false
                ];
                if( file_exists( Ninja_Forms::$dir . "build/dashboard.asset.php" ) ){
                    $asset_php = include( Ninja_Forms::$dir . "build/dashboard.asset.php" );
                    $dashboard_asset_php["dependencies"] = array_merge( $dashboard_asset_php["dependencies"], $asset_php["dependencies"]);
                    $dashboard_asset_php["version"] = $asset_php["version"];
                }
                //Get JS dashboard assets details
                if( file_exists( Ninja_Forms::$dir . "build/dashboard.scss.asset.php" ) ){
                    $asset_scss = include( Ninja_Forms::$dir . "build/dashboard.scss.asset.php" );
                }
                $dashboard_asset_scss_version = isset($asset_scss) ? $asset_scss["version"] : Ninja_Forms::VERSION;
                //Register Dashboard script
                wp_register_script( 'ninja_forms_admin_dashboard', Ninja_Forms::$url . 'build/dashboard.js',  $dashboard_asset_php["dependencies"], $dashboard_asset_php["version"], false );
                wp_enqueue_script( 'ninja_forms_admin_dashboard' );
                wp_set_script_translations( "ninja_forms_admin_dashboard", "ninja-forms", Ninja_Forms::$dir . 'lang' );
                //Enqueue dashboard style
                wp_enqueue_style( 'ninja_forms_admin_dashboard_style', Ninja_Forms::$url . 'build/dashboard.scss.css',  [], $dashboard_asset_scss_version );

                //Provide server side and saved data
                $addons_instance = new NF_Admin_Menus_Addons;
                $addons_data = $addons_instance->display();
                $services_data = Ninja_Forms()->config( 'DashboardServices' );
                wp_localize_script('ninja_forms_admin_dashboard', 'ninja_forms_admin_dashboard_data', [
                    'addonsData'                        =>  $addons_data,
                    'servicesData'                      =>  $services_data,
                    'siteUrl'                           =>  esc_url_raw( site_url() ),
                    'adminUrl'                          =>  esc_url_raw( admin_url() ),
                    'restUrl'                           =>  esc_url_raw( get_rest_url() ),
                    'ajaxUrl'                           =>  esc_url_raw( admin_url( 'admin-ajax.php' ) ),
                    'pluginDir'                         =>  plugin_dir_url('ninja-forms.php'),
                    'pluginURL'                         =>  NF_PLUGIN_URL,
                    'token'                             =>  wp_create_nonce( 'wp_rest' ),
                    'load_user_management'              =>  !in_array('ninja-forms-user-management/ninja-forms-user-management.php', get_option('active_plugins'))
                ]);
                
            }

        }
    }

    public function enqueue_telemetry_script($page) {
      
        // Load the script only on the Ninja Forms pages
        $nf_be_load_assets_for = [
            "toplevel_page_ninja-forms",
            "ninja-forms_page_nf-submissions",
            "ninja-forms_page_nf-forms",
            "ninja-forms_page_nf-settings",
            "ninja-forms_page_nf-system-status",
            "ninja-forms_page_nf-import-export"
        ];

        if( isset( $page ) && in_array( $page, $nf_be_load_assets_for ) ){
            // Get Dependencies and Version from build asset.php generated by wp-scripts
            $nf_be_data_asset_php = [
                "dependencies" => ['jquery'],
                "version"   => false
            ];
            // get active data from asset.php
            if( file_exists( Ninja_Forms::$url . "build/nf-behavioral.asset.php" ) ){
                $asset_php = include(Ninja_Forms::$url . "build/nf-behavioral.asset.php" );
                $nf_be_data_asset_php["dependencies"] = array_merge( $nf_be_data_asset_php["dependencies"], $asset_php["dependencies"]);
                $nf_be_data_asset_php["version"] = $asset_php["version"];
            }
            // Enqueue the script
            wp_enqueue_script('nf-be-data-script', Ninja_Forms::$url . 'build/nf-behavioral.js', $nf_be_data_asset_php["dependencies"], $nf_be_data_asset_php["version"], true);
            wp_localize_script('nf-be-data-script', 'nfBeData', [
                'restUrl'               =>  esc_url_raw( get_rest_url() ),
                'token'                 =>  wp_create_nonce( 'wp_rest' )
            ]);
            
        }
    }

} // End Class NF_Admin_Dashboard
