<?php

class LogoMarqueeModule extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name' => __('Logo Marquee', 'fl-builder'),
            'description' => __('A full-width continuous logo marquee.', 'fl-builder'),
            'category' => __('Custom Modules', 'fl-builder'),
            'dir' => plugin_dir_path(__FILE__),
            'url' => plugin_dir_url(__FILE__),
            'editor_export' => true,
            'enabled' => true,
            'icon'            => 'star-filled.svg',
            
        ]);

        $this->add_css('logo-marquee-style', $this->url . 'style.css');
    }
}

FLBuilder::register_module('LogoMarqueeModule', [
    'general' => [
        'title' => __('Content', 'fl-builder'),
        'sections' => [
            'main' => [
                'title' => __('Logo Section', 'fl-builder'),
                'fields' => [
                    'logos' => [
                        'type' => 'multiple-photos',
                        'label' => __('Upload Logos', 'fl-builder'),
                    ],
                ],
            ],
        ],
    ],
]);
