

function initVideoPlaylist() {
    // Select all buttons inside the video player
    const buttons = document.querySelectorAll("#video-player button");
  
    buttons.forEach(button => {
      button.removeEventListener("click", updateVideo); // Prevent duplicate event listeners
      button.addEventListener("click", updateVideo);
    });
  
    function updateVideo() {
      // Get data attributes from the clicked button
      const iframeSrc = this.getAttribute("data-iframe");
      const caption = this.getAttribute("data-caption");
  
      // Update the video caption and iframe src
      document.querySelector("#video-player #video-caption").innerHTML = caption;
      document.querySelector("#video-player iframe").setAttribute("src", iframeSrc);
  
      // Toggle the active class on the clicked button
      buttons.forEach(btn => btn.classList.remove("active"));
      this.classList.add("active");
    }
  
    // Scroll playlist horizontally with mouse wheel on hover
    const scrollContainer = document.querySelector("#playlist");
  
    if (scrollContainer) {
      scrollContainer.removeEventListener("wheel", scrollPlaylist); // Prevent duplicate event listeners
      scrollContainer.addEventListener("wheel", scrollPlaylist);
    }
  
    function scrollPlaylist(evt) {
      evt.preventDefault();
      scrollContainer.scrollLeft += evt.deltaY;
    }
  }
  
  // Initialize the video playlist when the page loads
  document.addEventListener("DOMContentLoaded", initVideoPlaylist);





document.addEventListener('DOMContentLoaded', function () {
    const player = document.getElementById('YouTube-Iframe');
    const caption = document.getElementById('video-caption');
    const buttons = document.querySelectorAll('#playlist button');

    buttons.forEach(button => {
        button.addEventListener('click', () => {
            // Remove active state from all
            buttons.forEach(btn => btn.classList.remove('active'));
            button.classList.add('active');

            // Update iframe and caption
            const iframeUrl = button.getAttribute('data-iframe');
            const videoCaption = button.getAttribute('data-caption');

            player.src = iframeUrl;
            caption.textContent = videoCaption;
        });
    });
});
