<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-video-gallery.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?> playlist-parent-container"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

 

         <aside id="video-player">

<?php if (!empty($settings->videos)) :
    // Get the first video
    $first_video = $settings->videos[0];
    $first_video_url = $first_video->video_url;

    // Convert to YouTube embed if needed
    if (strpos($first_video_url, 'youtube.com/watch?v=') !== false) {
        $video_id = preg_replace('/.*watch\?v=([^\&]+).*/', '$1', $first_video_url);
    } elseif (strpos($first_video_url, 'youtu.be/') !== false) {
        $video_id = preg_replace('/.*youtu\.be\/([^\?]+).*/', '$1', $first_video_url);
    } else {
        $video_id = ''; // fallback
    }

    // Embed URL for the first video
    $embed_url = $video_id ? 'https://www.youtube.com/embed/' . $video_id . '?enablejsapi=1' : '';
    
    // Check if the video has a custom thumbnail uploaded via media library
    $thumb_url = !empty($first_video->video_thumb) ? wp_get_attachment_url($first_video->video_thumb) : '//img.youtube.com/vi/' . $video_id . '/sddefault.jpg';

    // Validate the URL for thumbnail (if it's not valid, use the default image)
    if (!filter_var($thumb_url, FILTER_VALIDATE_URL)) {
        $thumb_url = '//img.youtube.com/vi/' . $video_id . '/sddefault.jpg'; // fallback to YouTube default
    }
    
    // Caption for the first video
    $caption = !empty($first_video->video_title) ? esc_html($first_video->video_title) : '';
?>

    <!-- PLAYER IFRAME -->
    <iframe id="YouTube-Iframe" loading="lazy" src="<?php echo esc_url($embed_url); ?>" frameborder="0"
        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
        allowfullscreen></iframe>

    <!-- VIDEO CAPTION -->
    <div id="video-caption"><?php echo $caption; ?></div>

    <!-- PLAYLIST -->
    <div id="playlist">
        <?php foreach ($settings->videos as $index => $video) :

            $vid_url = $video->video_url;
            if (strpos($vid_url, 'youtube.com/watch?v=') !== false) {
                $vid_id = preg_replace('/.*watch\?v=([^\&]+).*/', '$1', $vid_url);
            } elseif (strpos($vid_url, 'youtu.be/') !== false) {
                $vid_id = preg_replace('/.*youtu\.be\/([^\?]+).*/', '$1', $vid_url);
            } else {
                $vid_id = '';
            }

            $embed_link = $vid_id ? 'https://www.youtube.com/embed/' . $vid_id . '?autoplay=1' : '';
            
            // If custom thumbnail is set (uploaded from media library), use it
            $button_thumb = !empty($video->video_thumb) ? wp_get_attachment_url($video->video_thumb) : '//img.youtube.com/vi/' . $vid_id . '/sddefault.jpg';

            // Validate the button thumbnail URL
            if (!filter_var($button_thumb, FILTER_VALIDATE_URL)) {
                $button_thumb = '//img.youtube.com/vi/' . $vid_id . '/sddefault.jpg'; // fallback to YouTube default
            }
            
            // Button caption
            $btn_caption = !empty($video->video_title) ? esc_attr($video->video_title) : '';
            $is_active = $index === 0 ? ' class="active"' : '';

        ?>
            <button<?php echo $is_active; ?> style="background-image: url('<?php echo esc_url($button_thumb); ?>');"
                data-iframe="<?php echo esc_url($embed_link); ?>"
                <?php echo $btn_caption; ?>
            </button>
        <?php endforeach; ?>
    </div>

<?php endif; ?>
</aside>




</section>

<script src="<?php echo esc_url($module->url . 'js/az-video-gallery.js'); ?>"></script>


