<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Video_Gallery extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('Video Gallery Playlist', 'fl-builder'),
            'description'     => __('Playlist video source from media or from YouTube.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'format-video.svg',
        ]);

        // Enqueue any required scripts here
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    public function enqueue_scripts() {
        wp_enqueue_script(
            'prefixfree',
            get_stylesheet_directory_uri() . '/js/prefixfree-1.0.7.min.js',
            ['jquery'],
            '1.0.7',
            true
        );
    }
}

// Register the module settings
FLBuilder::register_settings_form('az_video_item_form', [
	'title' => __('Video Item', 'fl-builder'),
	'tabs'  => [
		'general' => [
			'title'    => __('General', 'fl-builder'),
			'sections' => [
				'main' => [
					'title'  => '',
					'fields' => [
						'video_title' => [
							'type'    => 'text',
							'label'   => __('Video Title', 'fl-builder'),
							'required' => true,
						],
						'video_url' => [
							'type'        => 'text',
							'label'       => __('Video URL', 'fl-builder'),
							'description' => __('YouTube or media file URL', 'fl-builder'),
						],
						'video_thumb' => [
							'type'  => 'photo',
							'label' => __('Thumbnail', 'fl-builder'),
						],
					],
				],
			],
		],
	],
]);



// Register the module itself
FLBuilder::register_module('AZ_Video_Gallery', [
	'settings' => [
		'title'    => __('Video Gallery Settings', 'fl-builder'),
		'sections' => [
			'video_list' => [
				'title'  => __('Videos', 'fl-builder'),
				'fields' => [
					'videos' => [
						'type'         => 'form',
						'label'        => __('Video Items', 'fl-builder'),
						'form'         => 'az_video_item_form',
						'preview_text' => 'video_title',
						'multiple'     => true,
					],
				],
			],
		],
	],
]);
