document.addEventListener("DOMContentLoaded", function () {
    const iframe = document.getElementById("videoplayer");
    const modal = document.getElementById("videoModal");
    const placeholder = '<!DOCTYPE html><h4 style="color: #FFFFFF; font-family: sans, arial; padding-top: 50px; text-align: center">Loading...</h4>';

    iframe.style.width = "100%";
    iframe.style.aspectRatio = "16 / 9";
    iframe.srcdoc = placeholder;

    document.querySelectorAll(".video").forEach(element => {
        element.addEventListener("click", function () {
            const videoId = this.id;
            iframe.removeAttribute("srcdoc");
            iframe.src = "https://www.youtube.com/embed/" + videoId + "?autoplay=1";
        });
    });

    modal.addEventListener("hidden.bs.modal", function () {
        iframe.removeAttribute("src");
        iframe.srcdoc = placeholder;
    });
});