<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);

// Helper to extract YouTube video ID from any valid format
function az_extract_youtube_id($url) {
    if (empty($url)) return '';
    $pattern = '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i';
    preg_match($pattern, $url, $matches);
    return !empty($matches[1]) ? $matches[1] : '';
}
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-video-gallery-grid.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

    <?php if (!empty($settings->videos)) : ?>
        <div class="container-fluid">
            <div class="row">
                <div class="col d-flex align-items-center flex-wrap gap-3">
                <?php foreach ($settings->videos as $video) :

                    $video_url = $video->video_url ?? '';
                    $video_id = az_extract_youtube_id($video_url);

                    // Allow direct video ID if extraction fails but still valid
                    if (!$video_id && preg_match('/^[a-zA-Z0-9_-]{11}$/', $video_url)) {
                        $video_id = $video_url;
                    }

                    // Skip if no valid video ID
                    if (!$video_id) continue;

                    // Get custom thumbnail if set
                    $thumb_url = '';
                    if (!empty($video->video_thumb)) {
                        $image = wp_get_attachment_image_src($video->video_thumb, 'medium');
                        if (!empty($image[0])) {
                            $thumb_url = esc_url($image[0]);
                        }
                    }

                    // Fallback to YouTube thumbnail
                    if (empty($thumb_url)) {
                        $thumb_url = "https://img.youtube.com/vi/$video_id/maxresdefault.jpg";
                    }

                    $title = esc_attr($video->video_title ?? 'Video');

                ?>
                    <div class="az-video-thumb video"
     id="<?php echo esc_attr($video_id); ?>"
     style="background-image: url('<?php echo esc_url($thumb_url); ?>');"
     title="<?php echo $title; ?>"
     data-bs-toggle="modal"
     data-bs-target="#videoModal">
     <i class="fab fa-youtube"></i>
     <div class="overlay"></div>
</div>

                <?php endforeach; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content bg-transparent border-0">
                <div class="modal-header bg-dark rounded-top-4">
                    <button type="button" class="btn-close btn-close-white shadow-none" data-bs-dismiss="modal" aria-label="Close"><i class="fas fa-times"></i></button>
                </div>
                <div class="modal-body overflow-hidden p-0">
                    <iframe class="bg-black rounded-bottom-4"
                            src=""
                            title="YouTube video player"
                            frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            allowfullscreen
                            id="videoplayer"></iframe>
                </div>
            </div>
        </div>
    </div>

</section>

<script src="<?php echo esc_url($module->url . 'js/az-video-gallery-grid.js'); ?>"></script>

