<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-testimonials-slider.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

    <?php if (!empty($settings->nav_color)) : ?>
    <style>
        #module-<?php echo esc_attr($module->slug); ?> .arrow,
        #module-<?php echo esc_attr($module->slug); ?> .dot {
            color: #<?php echo esc_attr($settings->nav_color); ?>;
        }

       #module-<?php echo esc_attr($module->slug); ?> .dot {
            border: 1px solid #<?php echo esc_attr($settings->nav_color); ?>;
        }
    </style>
    <?php endif; ?>

    <?php if (!empty($settings->nav_hover_color)) : ?>
    <style>
        #module-<?php echo esc_attr($module->slug); ?> .arrow:hover,
        #module-<?php echo esc_attr($module->slug); ?> .dot:hover {
            color: #<?php echo esc_attr($settings->nav_hover_color); ?>;
        }

        #module-<?php echo esc_attr($module->slug); ?> .dot.active, #module-<?php echo esc_attr($module->slug); ?> .dot:hover {
            background: #<?php echo esc_attr($settings->nav_hover_color); ?>;
        }
    </style>
    <?php endif; ?>

    <div class="wrap testim" id="testim">

        <span id="left-arrow" class="arrow left <?php echo esc_attr($settings->nav_icon_left); ?>"></span>
        <span id="right-arrow" class="arrow right <?php echo esc_attr($settings->nav_icon_right); ?>"></span>

        <ul id="testim-dots" class="dots">
            <?php if (!empty($settings->testimonials)) : ?>
                <?php foreach ($settings->testimonials as $index => $testimonial) : ?>
                    <li class="dot<?php echo $index === 0 ? ' active' : ''; ?>"></li>
                <?php endforeach; ?>
            <?php endif; ?>
        </ul>

        <div id="testim-content" class="cont">

            <?php if (!empty($settings->testimonials)) : ?>
                <?php foreach ($settings->testimonials as $index => $testimonial) : ?>
                    <?php
                    $image_url = is_numeric($testimonial->photo)
                        ? wp_get_attachment_url($testimonial->photo)
                        : esc_url($testimonial->photo);
                    ?>
                    <div class="<?php echo $index === 0 ? 'active' : ''; ?>">
                        <?php if ($image_url) : ?>
                            <div class="img">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($testimonial->name); ?>">
                            </div>
                        <?php endif; ?>

                        <h2><?php echo esc_html($testimonial->name); ?></h2>
                        <p><?php echo $testimonial->description; // allow HTML from editor ?></p>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

        </div>

    </div>
</section>

<script src="<?php echo esc_url($module->url . 'js/az-testimonials-slider.js'); ?>"></script>
