<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-testimonial-box.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

  <div class="testimonial_box">

  <?php foreach ($settings->testimonials as $index => $testimonial) : ?>
    <div class="testimonial" role="button" tabindex="0"
         aria-expanded="false"
         aria-label="Read testimonial from <?php echo esc_attr($testimonial->name); ?>">
        <div class="testim_content" id="testimonial-<?php echo $index; ?>">
            <button class="close-testimonial" aria-label="Close testimonial">&times;</button>
            <i class="fas fa-quote-left"></i>
            <div class="quote"><?php echo $testimonial->description; ?></div> <!-- Renders HTML -->
            <p class="name"><?php echo esc_html($testimonial->name); ?></p>
        </div>

        <?php
        $image_url = is_numeric($testimonial->photo)
            ? wp_get_attachment_url($testimonial->photo)
            : esc_url($testimonial->photo);
        ?>

        <?php if ($image_url) : ?>
            <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($testimonial->name); ?>">
        <?php endif; ?>
    </div>
<?php endforeach; ?>


  </div>

  <div class="testimonial-overlay" aria-hidden="true"></div>
</section>

<script src="<?php echo esc_url($module->url . 'js/az-testimonial-box.js'); ?>"></script>
