<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Testimonial_Box extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Testimonial Box', 'fl-builder'),
            'description'     => __('A Testimonials - ADA Compliant - HTML/CSS/jQuery', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'format-quote.svg',
        ]);
    }
}


FLBuilder::register_settings_form('az_testimonial_item_form', [
    'title' => __('Testimonial Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'name' => [
                            'type'  => 'text',
                            'label' => __('Name', 'fl-builder'),
                        ],
                        'description' => [
                            'type'          => 'editor',
                            'media_buttons' => true,
                            'wpautop'       => true
                        ],
                        'photo' => [
                            'type'  => 'photo',
                            'label' => __('Photo', 'fl-builder'),
                        ],
                    ]
                ]
            ]
        ]
    ]
]);


FLBuilder::register_module('AZ_Testimonial_Box', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [
                    'testimonials' => [
                        'type'  => 'form',
                        'label' => __('Testimonials', 'fl-builder'),
                        'form'  => 'az_testimonial_item_form', // Reference the form ID above
                        'preview_text' => 'name',
                        'multiple' => true,
                    ],
                ],
            ],
        ],
    ],
]);

