<?php

class AZ_Tabs_Module extends FLBuilderModule {
	public function __construct() {
		parent::__construct([
			'name'            => __('AZ Tabs', 'fl-builder'),
			'description'     => __('A tab module using Bootstrap.', 'fl-builder'),
			'category'        => __('Custom Modules', 'fl-builder'),
			'dir'             => plugin_dir_path(__FILE__),
			'url'             => plugin_dir_url(__FILE__),
			'editor_export'   => true,
			'enabled'         => true,
			'partial_refresh' => true,
			'icon'            => 'layout.svg',
		]);

		$this->add_css('az-tabs');
	}
}

// Register form
FLBuilder::register_settings_form('az_tab_item_form', [
	'title' => __('Tab Item', 'fl-builder'),
	'tabs'  => [
		'general' => [
			'title'    => __('General', 'fl-builder'),
			'sections' => [
				'main' => [
					'title'  => '',
					'fields' => [
						'title'   => [
							'type'  => 'text',
							'label' => __('Tab Title', 'fl-builder'),
						],
						'content' => [
							'type'  => 'editor',
							'label' => __('Tab Content', 'fl-builder'),
						],
					],
				],
			],
		],
	],
]);

// Register module
FLBuilder::register_module('AZ_Tabs_Module', [
    'general' => [ // 👈 this is the tab name
        'title'    => __('Tab Settings', 'fl-builder'),
        'sections' => [
            'content' => [
                'title'  => __('Tabs Content', 'fl-builder'),
                'fields' => [
                    'tabs' => [
                        'type'         => 'form',
                        'label'        => __('Tabs', 'fl-builder'),
                        'form'         => 'az_tab_item_form',
                        'preview_text' => 'title',
                        'multiple'     => true,
                    ],
                ],
            ],
        ],
    ],
]);
