<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<!-- Swiper Styles -->
<link rel="stylesheet" href="<?php echo esc_url( $module->url . 'css/az-swiper.css' ); ?>" />
<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/swiper-bundle.min.css" />

<section id="module-<?php echo esc_attr( $module->slug ); ?>"
         class="<?php echo esc_attr( $module->slug ); ?>"
         data-module="<?php echo esc_attr( $module_slug ); ?>">


<?php if (!empty($settings->nav_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-right,
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-left,
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet {
      color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet-active {
      background-color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
  </style>
<?php endif; ?>

<?php if (!empty($settings->nav_hover_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-right:hover,
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-left:hover {
      color: #<?php echo esc_attr($settings->nav_hover_color); ?>;
    }
  </style>
<?php endif; ?>


<?php if ( ! empty( $settings->manual_testimonials ) ) : ?>
<div class="az-swiper-wrapper"
     data-nav-color="<?php echo esc_attr( $settings->nav_color ); ?>"
     data-nav-hover-color="<?php echo esc_attr( $settings->nav_hover_color ); ?>"
     style="background-color: <?php echo esc_attr( $settings->bg_color ); ?>;">

    <!-- Swiper Container -->
    <div class="swiper az-swiper mySwiper">

        <!-- Slides Wrapper -->
        <div class="swiper-wrapper">
            <?php foreach ( $settings->manual_testimonials as $testimonial ) : ?>
                <div class="swiper-slide az-swiper-slide">
                    <div class="flex">

                    <?php
                    $is_image = isset( $testimonial->media_type ) && $testimonial->media_type === 'image';
                    $is_icon  = isset( $testimonial->media_type ) && $testimonial->media_type === 'icon';
                    ?>

                    <?php if ( $is_image && ! empty( $testimonial->photo ) ) : ?>
                        <img src="<?php echo esc_url( wp_get_attachment_url( $testimonial->photo ) ); ?>"
                             alt="<?php echo esc_attr( $testimonial->name ); ?>"
                             class="az-swiper-image" />
                    <?php elseif ( $is_icon && ! empty( $testimonial->icon ) ) : ?>
                        <i class="az-swiper-icon <?php echo esc_attr( $testimonial->icon ); ?>"></i>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->name ) ) : ?>
                        <h3 class="az-swiper-title"><?php echo esc_html( $testimonial->name ); ?></h3>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->description ) ) : ?>
                        <div class="az-swiper-description"><?php echo wp_kses_post( $testimonial->description ); ?></div>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->link_url ) ) : ?>
                        <p><a href="<?php echo esc_url( $testimonial->link_url ); ?>"
                              target="_blank" class="az-swiper-link">Read more</a></p>
                    <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        
    </div>

    <!-- Swiper Navigation & Pagination -->
        <div class="swiper-pagination"></div>
        <div class="swiper-button-prev">
            <i class="<?php echo esc_attr( $settings->nav_icon_left ); ?>"></i>
        </div>
        <div class="swiper-button-next">
            <i class="<?php echo esc_attr( $settings->nav_icon_right ); ?>"></i>
        </div>
        <div class="swiper-scrollbar d-none"></div>
</div>
<?php endif; ?>

</section>

<!-- Swiper JS -->
<script src="<?php echo get_stylesheet_directory_uri(); ?>/js/swiper-bundle.min.js"></script>

<!-- Swiper Initialization -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    var swiper = new Swiper(".mySwiper", {
      slidesPerView: 5,
      spaceBetween: 30,
      freeMode: true,
      autoplay: {
        delay: 3000,
        disableOnInteraction: false
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev"
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true
      },
      scrollbar: {
        el: ".swiper-scrollbar",
        draggable: true
      },
      breakpoints: {
        0: {
          slidesPerView: 1
        },
        768: {
          slidesPerView: 1
        },
        900: {
          slidesPerView: 3
        },
        1024: {
          slidesPerView: 4
        },
        1200: {
          slidesPerView: 4
        }
      }
    });
  });
</script>
