<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-swiper-vertical.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<?php if (!empty($settings->nav_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .c-testimonials__arrow-prev,
    #module-<?php echo esc_attr($module->slug); ?> .c-testimonials__arrow-next,
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet {
      color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet-active {
      background-color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
    #module-<?php echo esc_attr($module->slug); ?> .c-testimonials {
      background-color: #<?php echo esc_attr($settings->bg_color); ?>;
    }
  </style>
<?php endif; ?>

<?php if (!empty($settings->nav_hover_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .c-testimonials__arrow-prev:hover,
    #module-<?php echo esc_attr($module->slug); ?> .c-testimonials__arrow-next:hover {
      color: #<?php echo esc_attr($settings->nav_hover_color); ?>;
    }
  </style>
<?php endif; ?>

<div class="swiper c-testimonials">
  <ul class="swiper-wrapper c-testimonials__items">
    <?php if ($settings->source === 'manual' && !empty($settings->manual_testimonials)) : ?>
        <?php foreach ($settings->manual_testimonials as $item) :
            $image_url = is_numeric($item->photo) ? wp_get_attachment_url($item->photo) : esc_url($item->photo);
            ?>
            <li class="swiper-slide c-testimonials__item c-card-testimonial">
                <div class="c-card-testimonial__profile">
                    <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($item->name); ?>" class="c-card-testimonial__image">
                </div>
                <div class="c-card-testimonial__description">
                    <h3 class="Title"><?php echo esc_html($item->name); ?></h3>
                    <div class="c-card-testimonial__excerpt"><?php echo $item->description; ?></div>
                    <?php if (!empty($item->link_url)) : ?>
                      <a href="<?php echo esc_url($item->link_url); ?>" class="btn-link" target="_blank">
                        More on LinkedIn <i class="fas fa-chevron-right"></i>
                      </a>
                    <?php endif; ?>
                </div>
            </li>
        <?php endforeach; ?>

    <?php elseif ($settings->source === 'posts') : ?>
        <?php
        $args = [
            'post_type' => 'post',
            'posts_per_page' => 10,
            'category__in' => $settings->post_category,
        ];
        $query = new WP_Query($args);
        while ($query->have_posts()) : $query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            ?>
            <li class="swiper-slide c-testimonials__item c-card-testimonial">
                <div class="c-card-testimonial__profile">
                    <img src="<?php echo esc_url($thumb); ?>" alt="<?php the_title_attribute(); ?>" class="c-card-testimonial__image">
                </div>
                <div class="c-card-testimonial__description">
                    <h3 class="Title"><?php the_title(); ?></h3>
                    <div class="c-card-testimonial__excerpt"><?php echo wp_trim_words(get_the_excerpt(), 30); ?></div>
                    <a href="<?php the_permalink(); ?>" class="btn-link" target="_blank">
                      Read More <i class="fas fa-chevron-right"></i>
                    </a>
                </div>
            </li>
        <?php endwhile; wp_reset_postdata(); ?>
    <?php endif; ?>
  </ul>

  <div class="swiper-pagination c-testimonials__pagination"></div>

  <div class="c-testimonials__arrows">
  <button class="c-testimonials__arrow-prev" tabindex="0" role="button" aria-label="Previous slide">
    <i class="<?php echo esc_attr($settings->nav_icon_left); ?>"></i>
</button>

<button class="c-testimonials__arrow-next" tabindex="0" role="button" aria-label="Next slide">
    <i class="<?php echo esc_attr($settings->nav_icon_right); ?>"></i>
</button>

  </div>
</div>

</section>

