<?php

function fl_builder_get_category_options() {
    $categories = get_categories([
        'hide_empty' => false,
    ]);

    $options = [];

    foreach ($categories as $category) {
        $options[$category->term_id] = $category->name;
    }

    return $options;
}


if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Swiper_Vertical extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Swiper Vertical', 'fl-builder'),
            'description'     => __('Swiper verticle touch-friendly sliders and carousels', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'slides.svg',
        ]);
    }

    public function enqueue_scripts() {
        // Swiper CSS
        wp_enqueue_style(
            'swiper',
            get_stylesheet_directory_uri() . '/css/swiper.min.css',
            [],
            '8.4.5'
        );
    
        // Swiper JS
        wp_enqueue_script(
            'swiper-js',
            get_stylesheet_directory_uri() . '/js/swiper.min.js',
            [],
            '8.4.5',
            true
        );


        wp_enqueue_script(
            'az-swiper-init',
            $this->url . 'js/az-swiper-vertical.js', // your module's swiper setup script
            ['swiper-js'],
            '1.0.0',
            true
        );
    }

}

FLBuilder::register_settings_form('az_testimonial_manual_item_form', [
    'title' => __('Manual Testimonial Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'name' => [
                            'type'  => 'text',
                            'label' => __('Name', 'fl-builder'),
                        ],
                        'description' => [
                            'type'  => 'editor',
                            'label' => __('Description', 'fl-builder'),
                        ],
                        'photo' => [
                            'type'  => 'photo',
                            'label' => __('Photo', 'fl-builder'),
                        ],
                        'link_url' => [
                            'type'  => 'link',
                            'label' => __('Link URL', 'fl-builder'),
                        ],
                    ]
                ]
            ]
        ]
    ]
]);




FLBuilder::register_module('AZ_Swiper_Vertical', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [

                    'source' => [
    'type'    => 'select',
    'label'   => __('Data Source', 'fl-builder'),
    'default' => 'manual',
    'options' => [
        'manual' => __('Manual Entry', 'fl-builder'),
        'posts'  => __('Posts by Category', 'fl-builder'),
    ],
],

'manual_testimonials' => [
    'type'         => 'form',
    'label'        => __('Testimonials (Manual)', 'fl-builder'),
    'form'         => 'az_testimonial_manual_item_form',
    'preview_text' => 'name',
    'multiple'     => true,
    'connections'  => [],
    'show'         => [
        'source' => 'manual',
    ],
],

'post_category' => [
    'type'    => 'select',
    'label'   => __('Filter by Category', 'fl-builder'),
    'options' => fl_builder_get_category_options(), // or build dynamically
    'multiple' => true,
    'show'     => [
        'source' => 'posts',
    ],
],


                    // NEW FIELDS
                    'nav_icon_left' => [
    'type'  => 'icon',
    'label' => __('Left Arrow Icon', 'fl-builder'),
    'default' => 'fa fa-chevron-left',
],
'nav_icon_right' => [
    'type'  => 'icon',
    'label' => __('Right Arrow Icon', 'fl-builder'),
    'default' => 'fa fa-chevron-right',
],
'nav_color' => [
    'type'        => 'color',
    'label'       => __('Arrow & Bullet Color', 'fl-builder'),
    'default'     => '#333333',
    'show_reset'  => true,
],
'nav_hover_color' => [
    'type'        => 'color',
    'label'       => __('Arrow & Bullet Hover Color', 'fl-builder'),
    'default'     => '#1d9fd9',
    'show_reset'  => true,
],
'bg_color' => [
    'type'        => 'color',
    'label'       => __('Background Color', 'fl-builder'),
    'default'     => '#1d9fd9',
    'show_reset'  => true,
],

                ],
            ],
        ],
    ],
]);


