<?php
/**
 * AZ Share Social Module
 */

class AZShareSocialModule extends FLBuilderModule {

    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Share Social', 'fl-builder'),
            'description'     => __('Social media share buttons with customizable options.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
        ]);

        // Include frontend renderer
        $this->add_css('az-share-social');
        $this->add_js('az-share-social');
    }
}

FLBuilder::register_module('AZShareSocialModule', [
    'social_buttons' => [
        'title' => __('Social Buttons', 'fl-builder'),
        'sections' => [
            'social_settings' => [
                'title' => __('Buttons Settings', 'fl-builder'),
                'fields' => [
                    'show_facebook' => [
                        'type'    => 'select',
                        'label'   => __('Show Facebook', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'facebook_color' => [
                        'type'    => 'color',
                        'label'   => __('Facebook Color', 'fl-builder'),
                        'default' => '#1877F2',
                    ],
                    'show_twitter' => [
                        'type'    => 'select',
                        'label'   => __('Show Twitter', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'twitter_color' => [
                        'type'    => 'color',
                        'label'   => __('Twitter Color', 'fl-builder'),
                        'default' => '#1DA1F2',
                    ],
                    'show_linkedin' => [
                        'type'    => 'select',
                        'label'   => __('Show LinkedIn', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'linkedin_color' => [
                        'type'    => 'color',
                        'label'   => __('LinkedIn Color', 'fl-builder'),
                        'default' => '#0077B5',
                    ],
                    'show_whatsapp' => [
                        'type'    => 'select',
                        'label'   => __('Show WhatsApp', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'whatsapp_color' => [
                        'type'    => 'color',
                        'label'   => __('WhatsApp Color', 'fl-builder'),
                        'default' => '#25D366',
                    ],
                    'show_email' => [
                        'type'    => 'select',
                        'label'   => __('Show Email', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'email_color' => [
                        'type'    => 'color',
                        'label'   => __('Email Color', 'fl-builder'),
                        'default' => '#666666',
                    ]
                ]
            ]
        ]
    ]
]);
