<?php

function az_render_custom_post_layout($template, $settings) {
    $product = function_exists('wc_get_product') ? wc_get_product(get_the_ID()) : null;

    $tags = [
        '{{post_title}}'     => get_the_title(),
        '{{post_excerpt}}'   => wp_trim_words(get_the_excerpt(), isset($settings->excerpt_length) ? $settings->excerpt_length : 20),
        '{{post_permalink}}' => get_permalink(),
        '{{post_date}}'      => get_the_date('F j, Y'),
        '{{post_thumbnail}}' => get_the_post_thumbnail(null, 'medium'),
        '{{post_thumbnail_url}}' => get_the_post_thumbnail_url(null, 'medium'),
        '{{product_price}}'  => $product ? $product->get_price_html() : '',
        '{{add_to_cart}}'    => $product ? '<a href="?add-to-cart=' . esc_attr($product->get_id()) . '" class="button add_to_cart_button ajax_add_to_cart" data-product_id="' . esc_attr($product->get_id()) . '">Add to cart</a>' : '',
    ];

    return strtr($template, $tags);
}
