jQuery(document).ready(function($) {
    // Initialize Isotope
    var $grid = $('.az-post-list').isotope({
        itemSelector: '.az-post-item',
        layoutMode: 'fitRows',
        transitionDuration: '0.4s'
    });

    // Category filter
    $('.az-category-filter').on('click', '.az-filter-btn', function() {
        var filterValue = $(this).attr('data-cat');

        if (filterValue === 'all') {
            $grid.isotope({ filter: '*' });
        } else {
            $grid.isotope({
                filter: function() {
                    return $(this).attr('data-cats').split(' ').includes(filterValue);
                }
            });
        }

        $('.az-filter-btn').removeClass('active');
        $(this).addClass('active');
    });

    // Load More logic
    if (typeof window.azPostFilterSettings !== 'undefined' && window.azPostFilterSettings.settings.load_mode === 'load_more') {
        $('.az-load-more-btn').on('click', function() {
            var $button = $(this);
            var $list = $('.az-post-list');
            var paged = parseInt($list.attr('data-paged')) + 1;
            var max = parseInt($list.attr('data-max'));

            $.ajax({
                url: window.azPostFilterSettings.ajax_url,
                type: 'POST',
                data: {
                    action: 'az_load_more_posts',
                    paged: paged,
                    settings: window.azPostFilterSettings.settings
                },
                beforeSend: function() {
                    $button.text('Loading...');
                },
                success: function(res) {
                    if (res.success && res.html) {
                        var $newItems = $(res.html);
                        $list.append($newItems).isotope('appended', $newItems);
                        $list.attr('data-paged', paged);
                        if (paged >= max) {
                            $button.hide();
                        } else {
                            $button.text('Load More');
                        }
                    } else {
                        $button.text('No more posts');
                    }
                },
                error: function() {
                    $button.text('Error loading posts');
                }
            });
        });
    }
});
