<?php
$settings        = $module->settings;
$layout          = isset($settings->layout_type) ? $settings->layout_type : 'carousel';
$post_count      = !empty($settings->posts_count) ? intval($settings->posts_count) : 6;
$custom_layout   = !empty($settings->custom_layout_code) ? $settings->custom_layout_code : '';
$module_id       = 'mod_' . $module->node;

$paged_key       = 'az_paged_' . $module_id;
$paged           = isset($_GET[$paged_key]) ? intval($_GET[$paged_key]) : 1;
$pagination_type = !empty($settings->pagination_type) ? $settings->pagination_type : 'numbers';
$post_type       = !empty($settings->post_type) ? $settings->post_type : 'post';
$taxonomy_filter = !empty($settings->category_filter) ? $settings->category_filter : '';

$args = [
    'post_type'      => $post_type,
    'posts_per_page' => $post_count,
    'paged'          => $paged,
    'orderby'        => 'date',
    'order'          => 'DESC',
];

// Taxonomy filter
if (!empty($taxonomy_filter)) {
    $taxonomy = ($post_type === 'product') ? 'product_cat' : 'category';
    $args['tax_query'][] = [
        'taxonomy' => $taxonomy,
        'field'    => 'slug',
        'terms'    => explode(',', $taxonomy_filter),
    ];
}

// ACF filtering
if (!empty($settings->acf_key) && !empty($settings->acf_value)) {
    $args['meta_query'][] = [
        'key'     => $settings->acf_key,
        'value'   => $settings->acf_value,
        'compare' => '='
    ];
}

$loop = new WP_Query($args);
$module_slug = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-post-grid.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<div class="az-post-grid-wrapper <?php echo esc_attr($layout); ?>">

<?php if ($layout === 'carousel'): ?>
    <div class="swiper az-swiper">
        <div class="swiper-wrapper">
            <?php if ($loop->have_posts()) : ?>
                <?php while ($loop->have_posts()): $loop->the_post(); ?>
                    <div class="swiper-slide">
                        <?php
                        if (!empty($custom_layout)) {
                            echo az_render_custom_post_layout($custom_layout, $settings);
                        } else {
                            get_template_part('partials/az-post-card', null, [
                                'settings'   => $settings,
                                'post_type'  => $post_type,
                            ]);
                        }
                        ?>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="swiper-slide az-no-posts"><p>No posts found.</p></div>
            <?php endif; ?>
        </div>

        <div class="swiper-button-prev"><?php echo !empty($settings->prev_icon) ? '<i class="' . esc_attr($settings->prev_icon) . '"></i>' : 'Prev'; ?></div>
        <div class="swiper-button-next"><?php echo !empty($settings->next_icon) ? '<i class="' . esc_attr($settings->next_icon) . '"></i>' : 'Next'; ?></div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function () {
        new Swiper('.az-swiper', {
            slidesPerView: 1,
            loop: <?php echo $settings->loop === 'true' ? 'true' : 'false'; ?>,
            autoplay: <?php echo $settings->autoplay === '1' ? '{ delay: 3000, disableOnInteraction: false }' : 'false'; ?>,
            spaceBetween: 20,
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            breakpoints: {
                768: { slidesPerView: 2 },
                1024: { slidesPerView: 3 }
            }
        });
    });
    </script>

<?php else: ?>
    <div class="az-grid-layout">
        <?php if ($loop->have_posts()) : ?>
            <?php while ($loop->have_posts()): $loop->the_post(); ?>
                <div class="az-grid-item">
                    <?php
                    if (!empty($custom_layout)) {
                        echo az_render_custom_post_layout($custom_layout, $settings);
                    } else {
                        get_template_part('partials/az-post-card', null, [
                            'settings'   => $settings,
                            'post_type'  => $post_type,
                        ]);
                    }
                    ?>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="az-no-posts">
                <p>No posts found.</p>
            </div>
        <?php endif; ?>
    </div>

    <?php if ($pagination_type === 'numbers' && $loop->max_num_pages > 1): ?>
        <div class="az-pagination-numbers">
            <?php
            echo paginate_links([
                'total'   => $loop->max_num_pages,
                'current' => $paged,
                'format'  => '?' . $paged_key . '=%#%',
                'prev_text' => __('« Prev'),
                'next_text' => __('Next »'),
            ]);
            ?>
        </div>
    <?php elseif ($pagination_type === 'load_more' && $loop->max_num_pages > 1): ?>
        <div class="az-load-more-wrap">
            <button id="az-load-more" data-page="1" data-max="<?php echo esc_attr($loop->max_num_pages); ?>">
                <?php echo !empty($settings->load_more_text) ? esc_html($settings->load_more_text) : 'Load More'; ?>
            </button>
        </div>

        <script>
        document.addEventListener('DOMContentLoaded', function () {
            const loadMoreBtn = document.getElementById('az-load-more');
            const container = document.querySelector('.az-grid-layout');

            loadMoreBtn.addEventListener('click', function () {
                let page = parseInt(this.dataset.page) + 1;
                const max = parseInt(this.dataset.max);
                const button = this;

                fetch('<?php echo site_url(); ?>/wp-admin/admin-ajax.php?action=az_custom_load_more_posts&page=' + page)
                    .then(res => res.text())
                    .then(html => {
                        container.insertAdjacentHTML('beforeend', html);
                        this.dataset.page = page;
                        if (page >= max) button.remove();
                    });
            });
        });
        </script>
    <?php endif; ?>
<?php endif; ?>
</div>

</section>

<?php wp_reset_postdata(); ?>
