<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Pillar extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Pillar', 'fl-builder'),
            'description'     => __('A Pillar Design', 'fl-builder'),
            'category'        => __('ToYM', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'star-filled.svg',
        ]);
    }
}

FLBuilder::register_module('AZ_Pillar', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Main Section', 'fl-builder'),
                'fields' => [

                    'text_field' => [
                        'type'    => 'text',
                        'label'   => __('Text Field', 'fl-builder'),
                        'default' => 'Sample text',
                    ],

                    'editor_field' => [
                        'type'    => 'editor',
                        'label'   => __('Editor Field', 'fl-builder'),
                        'default' => '',
                    ],

                    'photo_field' => [
                    'type'    => 'photo',
                    'label'   => __('Photo Field', 'fl-builder'),
                    'show_remove' => true,
                    'preview' => 'photo',
                    'connections' => ['url'],
                    ],

                    'items' => array(
                    'type'          => 'form',
                    'label'         => __('Items', 'fl-builder'),
                    'form'          => 'az_pillar_item_form', // reference to the repeater form
                    'preview_text'  => 'title',
                    'multiple'      => true,
                ),


                ],
            ],
        ],
    ],
]);




FLBuilder::register_settings_form('az_pillar_item_form', array(
    'title' => __('Service Item', 'fl-builder'),
    'tabs'  => array(
        'general' => array(
            'title' => __('General', 'fl-builder'),
            'sections' => array(
                'main' => array(
                    'fields' => array(
                       'icon' => array(
    'type'        => 'photo', // ← SWITCHED FROM 'media' to 'photo'
    'label'       => __('Icon (SVG Supported)', 'fl-builder'),
    'show_remove' => true,
    'preview'     => 'default',
),



                        'title' => array(
                            'type'  => 'text',
                            'label' => __('Title', 'fl-builder'),
                        ),
                        'description' => array(
                            'type'  => 'textarea',
                            'label' => __('Description', 'fl-builder'),
                        ),
                        'link' => array(
                            'type'        => 'link',
                            'label'       => __('Link URL', 'fl-builder'),
                            'show_target' => true,
                        ),
                    ),
                ),
            ),
        ),
    ),
));

