<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$global_icon_color = $settings->use_global_icon_color === 'yes' ? $settings->global_icon_color : false;
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-list.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<?php
$global_icon = $settings->use_global_icon === 'yes' ? $settings->global_icon : false;
$items = $settings->items;

if (!empty($items)) :
?>
<ul class="az-list">
    <?php foreach ($items as $item) :
        $icon      = $global_icon ?: $item->icon;
        $icon_size = !empty($item->icon_size) ? intval($item->icon_size) : 16;
        $font_size = !empty($item->font_size) ? intval($item->font_size) : 16;
        $text_color = !empty($item->text_color) ? $item->text_color : '000';
        $icon_color = $global_icon_color ?: (isset($item->icon_color) ? $item->icon_color : '#000');

        $icon_style = "font-size: {$icon_size}px; color: {$icon_color} !important; margin-right: 8px;";
        $text_style = "font-size: {$font_size}px; color: {$text_color} !important;";
    ?>
        <li class="az-list-item" style="<?php echo esc_attr($text_style); ?>">
            <?php if (!empty($icon)) : ?>
                <i class="<?php echo esc_attr($icon); ?>" style="<?php echo esc_attr($icon_style); ?>"></i>
            <?php endif; ?>
            <?php echo esc_html($item->text); ?>
        </li>
    <?php endforeach; ?>
</ul>
<?php endif; ?>

</section>

<script src="<?php echo esc_url($module->url . 'js/az-list.js'); ?>"></script>
