<?php
/**
 * AZ List Module
 */

class AZ_List_Module extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ List', 'fl-builder'),
            'description'     => __('A simple list with icons.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'list.svg',
        ]);

        $this->add_css('new-module');
        $this->add_js('new-module');
    }
}

FLBuilder::register_module('AZ_List_Module', [
    'general' => [
        'title'    => __('List Settings', 'fl-builder'),
        'sections' => [
            'general' => [
                'title'  => __('General', 'fl-builder'),
                'fields' => [
                    'use_global_icon' => [
                        'type'    => 'select',
                        'label'   => __('Use same icon for all?', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'global_icon' => [
                        'type'        => 'icon',
                        'label'       => __('Global Icon', 'fl-builder'),
                        'show_remove' => true,
                        'preview'     => 'font',
                        'connections' => [ 'string' ],
                        'depends'     => [
                            'use_global_icon' => 'yes'
                        ]
                    ],
                    'use_global_icon_color' => [
                        'type'    => 'select',
                        'label'   => __('Use same icon color for all?', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder')
                        ]
                    ],
                    'global_icon_color' => [
    'type'        => 'color',
    'label'       => __('Global Icon Color', 'fl-builder'),
    'show_reset'  => true,
    'depends'     => [
        'use_global_icon_color' => 'yes'
    ]
],

                ]
            ],
        ]
    ],
    'items' => [
        'title'    => __('List Items', 'fl-builder'),
        'sections' => [
            'items_section' => [
                'title'  => __('Items', 'fl-builder'),
                'fields' => [
                    'items' => [
                        'type'         => 'form',
                        'label'        => __('Items', 'fl-builder'),
                        'form'         => 'az_list_item_form',
                        'preview_text' => 'text',
                        'multiple'     => true,
                    ],
                ]
            ]
        ]
    ],
]);

FLBuilder::register_settings_form('az_list_item_form', [
    'title' => __('List Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'text' => [
                            'type'  => 'text',
                            'label' => __('Item Text', 'fl-builder')
                        ],
                        'icon' => [
                            'type'        => 'icon',
                            'label'       => __('Icon', 'fl-builder'),
                            'show_remove' => true,
                            'preview'     => 'font'
                        ],
                        'icon_size' => [
                            'type'    => 'unit',
                            'label'   => __('Icon Size', 'fl-builder'),
                            'default' => '16',
                            'units'   => ['px']
                        ],
                        'font_size' => [
                            'type'    => 'unit',
                            'label'   => __('Font Size', 'fl-builder'),
                            'default' => '16',
                            'units'   => ['px']
                        ],
                        'text_color' => [
    'type'        => 'color',
    'label'       => __('Text Color', 'fl-builder'),
    'show_reset'  => true,
],

'icon_color' => [
    'type'        => 'color',
    'label'       => __('Icon Color', 'fl-builder'),
    'show_reset'  => true,
]

                    ]
                ]
            ]
        ]
    ]
]);
