<?php
$tag = $settings->heading_tag;
$title = $settings->title;
$desc = $settings->description;
$align = $settings->content_align;
$bg_url = isset($settings->bg_image) ? wp_get_attachment_url($settings->bg_image) : '';
$fixed = ($settings->bg_fixed === 'yes') ? 'fixed' : 'scroll';
$show_desc = ($settings->show_description === 'yes');
$show_breadcrumb = ($settings->show_breadcrumb === 'yes');
$heading_color = !empty($settings->heading_color) ? $settings->heading_color : '#ffffff';

$height_desktop = !empty($settings->height_dekstop) ? $settings->height_dekstop : '400';
$height_laptop  = !empty($settings->height_laptop) ? $settings->height_laptop : '300';
$height_ipad    = !empty($settings->height_ipad) ? $settings->height_ipad : '250';
$height_mobile  = !empty($settings->height_mobile) ? $settings->height_mobile : '200';

$overlay_type = $settings->overlay_type ?? 'overlay';
$overlay_color = $settings->overlay_color ?? 'rgba(0,0,0,0.5)';
$solid_color = $settings->solid_color ?? '#000';

$bg_style = $overlay_type === 'solid'
    ? "background-color: {$solid_color};"
    : "background-image: url('" . esc_url($bg_url) . "');";

$module_slug  = sanitize_html_class($module->slug);
$module_id = 'az-banner-' . uniqid();
?>



<section id="<?php echo esc_attr($module_id); ?>" class="<?php echo esc_attr($module_slug); ?>" data-module="<?php echo esc_attr($module_slug); ?>">
    <div class="az-inner-banner" style="<?php echo $bg_style; ?>">
        <?php if ($overlay_type === 'overlay') : ?>
            <div class="az-inner-banner-overlay" style="animation-duration: 1s; animation-delay: 0.3s; animation-duration: 1s; background-color: #<?php echo esc_attr($overlay_color); ?>"></div>
        <?php endif; ?>

        <div class="az-inner-banner-content align-<?php echo esc_attr($align); ?>">
            <<?php echo $tag; ?> class="az-inner-banner-title fl-animation fl-fade-down fl-animated" style="color: #<?php echo esc_attr($heading_color); ?>;">
                <?php echo esc_html($title); ?>
            </<?php echo $tag; ?>>

            <?php if ($show_desc && !empty($desc)) : ?>
                <div class="az-inner-banner-description"><?php echo nl2br(esc_html($desc)); ?></div>
            <?php endif; ?>

            <?php if ($show_breadcrumb) : ?>
    <div class="az-inner-banner-breadcrumb">
        <?php if (function_exists('yoast_breadcrumb')) : ?>
            <?php yoast_breadcrumb('<p id="breadcrumbs">', '</p>'); ?>
        <?php else : ?>
            <p id="breadcrumbs">
                <a href="<?php echo esc_url(home_url('/')); ?>">Home</a> &gt;
                <span><?php echo esc_html(get_the_title()); ?></span>
            </p>
        <?php endif; ?>
    </div>
<?php endif; ?>


        </div>
    </div>
</section>

<script src="<?php echo esc_url($module->url . 'js/az-inner-banner.js'); ?>"></script>
