<?php
/**
 * AZ Inner Banner Module
 */
class AZ_Inner_Banner_Module extends FLBuilderModule {

    public function __construct()
    {
        parent::__construct([
            'name'            => __('AZ Inner Banner', 'fl-builder'),
            'description'     => __('Banner with title, description, background, breadcrumb', 'fl-builder'),
            'category'        => __('AZ Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'partial_refresh' => true,
        ]);
    }

    public function enqueue_scripts()
    {
        $this->add_css('az-inner-banner-css', $this->url . 'css/az-inner-banner.css');
    }
}

FLBuilder::register_module('AZ_Inner_Banner_Module', [
    'general' => [
        'title' => __('Content', 'fl-builder'),
        'sections' => [
            'main' => [
                'title' => __('Banner Settings', 'fl-builder'),
                'fields' => [
                    'title' => [
                        'type'  => 'text',
                        'label' => __('Title', 'fl-builder'),
                        'default' => __('Page Title', 'fl-builder'),
                    ],
                    'heading_tag' => [
                        'type'    => 'select',
                        'label'   => __('Heading Level', 'fl-builder'),
                        'default' => 'h1',
                        'options' => [
                            'h1' => 'H1',
                            'h2' => 'H2',
                            'h3' => 'H3',
                            'h4' => 'H4',
                            'h5' => 'H5',
                        ]
                    ],
                    'font' => [
                        'type'  => 'font',
                        'label' => __('Heading Font', 'fl-builder')
                    ],
                    'heading_color' => [
                        'type'  => 'color',
                        'label' => __('Heading Color', 'fl-builder'),
                        'show_reset' => true,
                    ],
                    'description' => [
                        'type'    => 'textarea',
                        'label'   => __('Description', 'fl-builder'),
                        'default' => ''
                    ],
                    'show_description' => [
                        'type'    => 'select',
                        'label'   => __('Show Description?', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ]
                    ],
                    'show_breadcrumb' => [
                        'type'    => 'select',
                        'label'   => __('Show Breadcrumb?', 'fl-builder'),
                        'default' => 'yes',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ]
                    ],
                    'bg_image' => [
                        'type'  => 'photo',
                        'label' => __('Background Image', 'fl-builder')
                    ],
                    'bg_fixed' => [
                        'type'    => 'select',
                        'label'   => __('Fixed Background?', 'fl-builder'),
                        'default' => 'no',
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ]
                    ],
                    'overlay_type' => [
    'type'    => 'select',
    'label'   => __('Background Type', 'fl-builder'),
    'default' => 'overlay',
    'options' => [
        'overlay' => __('Overlay on Image', 'fl-builder'),
        'solid'   => __('Solid Color', 'fl-builder'),
    ]
],
'solid_color' => [
    'type'       => 'color',
    'label'      => __('Solid Background Color', 'fl-builder'),
    'show_reset' => true,
    'connections' => ['color'],
    'show_if'    => ['overlay_type' => 'solid']
],


                    'content_align' => [
                        'type'    => 'align',
                        'label'   => __('Content Alignment', 'fl-builder'),
                        'default' => 'center',
                        'responsive' => true
                    ],
                    'height_dekstop' => [
                        'type'        => 'unit',
                        'label'       => __('Height (Desktop)', 'fl-builder'),
                        'default'     => '400',
                        'placeholder' => '400',
                        'units'       => ['px'],
                    ],
                    'height_laptop' => [
                        'type'        => 'unit',
                        'label'       => __('Height (Laptop)', 'fl-builder'),
                        'default'     => '300',
                        'placeholder' => '300',
                        'units'       => ['px'],
                    ],
                    'height_ipad' => [
                        'type'        => 'unit',
                        'label'       => __('Height (Ipad)', 'fl-builder'),
                        'default'     => '250',
                        'placeholder' => '250',
                        'units'       => ['px'],
                    ],
                    'height_mobile' => [
                        'type'        => 'unit',
                        'label'       => __('Height (Mobile)', 'fl-builder'),
                        'default'     => '200',
                        'placeholder' => '200',
                        'units'       => ['px'],
                    ],
                ]
            ]
        ]
    ]
]);
