<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Image_Sphere extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('Image Sphere', 'fl-builder'),
            'description'     => __('Image Sphere With Border.', 'fl-builder'),
            'category'        => __('ToYM', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'star-filled.svg',
        ]);
    }
}

FLBuilder::register_module('AZ_Image_Sphere', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Main Section', 'fl-builder'),
                'fields' => [
    'photo_field' => [
    'type'    => 'photo',
    'label'   => __('Photo Field', 'fl-builder'),
    'show_remove' => true,
    'preview' => 'photo',
    'connections' => ['url'],
],

    'width' => [
        'type'        => 'unit',
        'label'       => __('Width', 'fl-builder'),
        'default'     => '500',
        'responsive'  => true,
        'units'       => ['px', '%', 'vw'],
    ],
    'height' => [
        'type'        => 'unit',
        'label'       => __('Height', 'fl-builder'),
        'default'     => '500',
        'responsive'  => true,
        'units'       => ['px', '%', 'vh'],
    ],
],

            ],
        ],
    ],
]);
