<?php
$module_slug = sanitize_html_class( $module->slug );
$settings = $module->settings;
$items = $settings->flip_items ?? [];
$color_heading = $settings->color_field_heading;
$color_description = $settings->color_field_description;
$color_background = $settings->color_field_background;


if ($color_heading && strpos($color_heading, '#') !== 0) {
    $color_heading = '#' . $color_heading;
}

if ($color_description && strpos($color_description, '#') !== 0) {
    $color_description = '#' . $color_description;
}

if ($color_background && strpos($color_background, '#') !== 0) {
    $color_background = '#' . $color_background;
}

?>

<link rel="stylesheet" href="<?php echo esc_url( $module->url . 'css/az-flip-grid.css' ); ?>" />

<section  id="module-<?php echo esc_attr( $module->slug ); ?>" class="<?php echo esc_attr( $module->slug ); ?>" data-module="<?php echo esc_attr( $module_slug ); ?>">


<ul class="grid">
<?php foreach ($settings->items as $item): ?>
	<?php
		$style = isset($item->style_type) && $item->style_type === 'style2' ? '2' : '';
		$image_url = $item->image_src['url'] ?? ''; // ✅ ensure url exists
	?>
	<li>
		<div class="dm-flip-card<?php echo $style; ?>">
        <div class="dm-front-card<?php echo $style; ?>" style="background-image: url('<?php echo esc_url($item->image_src_src); ?>');"></div>

			<div class="dm-back-card<?php echo $style; ?>" style="background: <?php echo esc_attr($color_background); ?>;">
				<h5 style="color: <?php echo esc_attr($color_heading); ?>;"><?php echo esc_html($item->title); ?></h5>
				<p style="color: <?php echo esc_attr($color_description); ?>;"><?php echo esc_html($item->description); ?></p>
				<?php if (!empty($item->link)) : ?>
    <a href="<?php echo esc_url($item->link); ?>" class="az-btn">Learn More</a>
<?php endif; ?>

			</div>
		</div>
	</li>
<?php endforeach; ?>
</ul>



</section>
