<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
$target_date  = !empty($settings->target_date) ? $settings->target_date : '2025-12-31';

?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-countdown.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

  <div id="countdown">
    <ul>
      <li><span id="days"></span>Days</li>
      <li><span id="hours"></span>Hours</li>
      <li><span id="minutes"></span>Minutes</li>
      <li><span id="seconds"></span>Seconds</li>
    </ul>
  </div>

  <div id="content" style="display:none;">
    <p>Countdown complete!</p>
  </div>

</section>

<!-- ✅ Define targetDate in JS -->
<script>
  const targetDate = "<?php echo esc_js($target_date); ?>";
</script>

<!-- ✅ Countdown Script -->
<script  src="<?php echo esc_url($module->url . 'js/az-countdown.js'); ?>"></script>
