<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Countdown_Module extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Countdown', 'fl-builder'),
            'description'     => __('A clean starter module.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'clock.svg',
        ]);
    }
}

FLBuilder::register_module('AZ_Countdown_Module', [
    'general' => [
        'title'    => __('Countdown Settings', 'fl-builder'),
        'sections' => [
            'settings' => [
                'title'  => __('Date Settings', 'fl-builder'),
                'fields' => [
                    'target_date' => [
                        'type'  => 'date',
                        'label' => __('Target Date', 'fl-builder'),
                        'description' => __('Select the target date for the countdown.', 'fl-builder'),
                    ],
                ],
            ],
        ],
    ],
]);

