const testimonials = window.azCircularTestimonials || [];


        let activeIndex = 0;
        const imageContainer = document.getElementById('image-container');
        const nameElement = document.getElementById('name');
        const designationElement = document.getElementById('designation');
        const quoteElement = document.getElementById('quote');
        const prevButton = document.getElementById('prev-button');
        const nextButton = document.getElementById('next-button');

        function calculateGap(width) {
            const minWidth = 1024;
            const maxWidth = 1456;
            const minGap = 60;
            const maxGap = 86;

            if (width <= minWidth) return minGap;
            if (width >= maxWidth) return Math.max(minGap, maxGap + 0.06018 * (width - maxWidth));

            return minGap + (maxGap - minGap) * ((width - minWidth) / (maxWidth - minWidth));
        }

        function updateTestimonial(direction) {
            if (!testimonials.length) return;
        
            const oldIndex = activeIndex;
            activeIndex = (activeIndex + direction + testimonials.length) % testimonials.length;
        
            const containerWidth = imageContainer.offsetWidth;
            const gap = calculateGap(containerWidth);
            const maxStickUp = gap * 0.8;
        
            // Clear unused images
            const existingImages = imageContainer.querySelectorAll('img');
            existingImages.forEach(img => {
                if (
                    parseInt(img.dataset.index) !== activeIndex &&
                    parseInt(img.dataset.index) !== (activeIndex - 1 + testimonials.length) % testimonials.length &&
                    parseInt(img.dataset.index) !== (activeIndex + 1) % testimonials.length
                ) {
                    imageContainer.removeChild(img);
                }
            });
        
            const visibleIndexes = [
                (activeIndex - 1 + testimonials.length) % testimonials.length, // prev
                activeIndex,
                (activeIndex + 1) % testimonials.length  // next
            ];
        
            visibleIndexes.forEach((index) => {
                const testimonial = testimonials[index];
                let img = imageContainer.querySelector(`[data-index="${index}"]`);
                if (!img) {
                    img = document.createElement('img');
                    img.src = testimonial.src;
                    img.alt = testimonial.name;
                    img.classList.add('testimonial-image');
                    img.dataset.index = index;
                    imageContainer.appendChild(img);
                }
        
                let translateX = '0%', translateY = '0%', rotateY = 0, scale = 1;
                let zIndex = 3, opacity = 1;
        
                if (index === activeIndex) {
                    // center
                    translateX = '0%';
                    translateY = '0%';
                    rotateY = 0;
                    scale = 1;
                    zIndex = 3;
                } else if (index === (activeIndex - 1 + testimonials.length) % testimonials.length) {
                    // left
                    translateX = '-20%';
                    translateY = `-${maxStickUp / img.offsetHeight * 100}%`;
                    rotateY = 15;
                    scale = 0.85;
                    zIndex = 2;
                } else if (index === (activeIndex + 1) % testimonials.length) {
                    // right
                    translateX = '20%';
                    translateY = `-${maxStickUp / img.offsetHeight * 100}%`;
                    rotateY = -15;
                    scale = 0.85;
                    zIndex = 2;
                } else {
                    opacity = 0;
                    zIndex = 1;
                }
        
                gsap.to(img, {
                    zIndex: zIndex,
                    opacity: opacity,
                    scale: scale,
                    x: translateX,
                    y: translateY,
                    rotateY: rotateY,
                    duration: 0.8,
                    ease: "power3.out"
                });
            });
        
            // Animate text content
            gsap.to([nameElement, designationElement], {
                opacity: 0,
                y: -20,
                duration: 0.3,
                ease: "power2.in",
                onComplete: () => {
                    nameElement.textContent = testimonials[activeIndex].name;
                    designationElement.textContent = testimonials[activeIndex].designation || '';
                    gsap.to([nameElement, designationElement], {
                        opacity: 1,
                        y: 0,
                        duration: 0.3,
                        ease: "power2.out"
                    });
                }
            });
        
            gsap.to(quoteElement, {
                opacity: 0,
                y: -20,
                duration: 0.3,
                ease: "power2.in",
                onComplete: () => {
                    quoteElement.innerHTML = testimonials[activeIndex].quote.split(' ').map(word => `<span class="word">${word}</span>`).join(' ');
                    gsap.to(quoteElement, {
                        opacity: 1,
                        y: 0,
                        duration: 0.3,
                        ease: "power2.out"
                    });
                    animateWords();
                }
            });
        }
        

        function animateWords() {
            gsap.from('.word', {
                opacity: 0,
                y: 10,
                stagger: 0.02,
                duration: 0.2,
                ease: "power2.out"
            });
        }

        function handleNext() {
            updateTestimonial(1);
        }

        function handlePrev() {
            updateTestimonial(-1);
        }

        prevButton.addEventListener('click', handlePrev);
        nextButton.addEventListener('click', handleNext);

        // Initial setup
        updateTestimonial(0);

        // Autoplay functionality
        const autoplayInterval = setInterval(handleNext, 5000);

        // Stop autoplay on user interaction
        [prevButton, nextButton].forEach(button => {
            button.addEventListener('click', () => {
                clearInterval(autoplayInterval);
            });
        });

        // Handle window resize
        window.addEventListener('resize', () => updateTestimonial(0));