<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-carousel-slider-swiper.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module_slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

    <?php
    // Grab first slide background image (for initial state)
    $initial_bg = '';
    if ( ! empty( $settings->testimonials ) && ! empty( $settings->testimonials[0]->bg_image ) ) {
        $initial_bg = wp_get_attachment_image_url( $settings->testimonials[0]->bg_image, 'full' );
    }
    ?>

    <div class="carousel-slider" style="background-image: url('<?php echo esc_url($initial_bg); ?>'); background-size: cover; background-position: center;">
        <div class="swiper-wrapper">

            <?php if ( ! empty( $settings->testimonials ) ) : ?>
                <?php foreach ( $settings->testimonials as $testimonial ) : ?>
                    <?php
                    $image_url = ! empty( $testimonial->image ) ? wp_get_attachment_image_url( $testimonial->image, 'full' ) : '';
                    $bg_url    = ! empty( $testimonial->bg_image ) ? wp_get_attachment_image_url( $testimonial->bg_image, 'full' ) : '';

                    // Flexible link handling (array or string)
                    $link_url = '';
                    $link_target = '_self';

                    if ( is_array( $testimonial->link ) ) {
                        $link_url    = ! empty( $testimonial->link['url'] ) ? $testimonial->link['url'] : '';
                        $link_target = ! empty( $testimonial->link['target'] ) ? $testimonial->link['target'] : '_self';
                    } elseif ( is_string( $testimonial->link ) ) {
                        $link_url = $testimonial->link;
                        $link_target = '_blank';
                    }
                    ?>
                    <div class="swiper-slide" data-bg="<?php echo esc_url( $bg_url ); ?>">
                        <div class="item-content">
                            <div class="row flex">
                                <div class="col flex">
                                    <?php if ( ! empty( $image_url ) ) : ?>
                                        <img class="profile" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $testimonial->name ); ?>">
                                    <?php endif; ?>
                                    <h4><?php echo esc_html( $testimonial->name ); ?></h4>
                                </div>

                                <div class="col">
                                    <ul class="star">
                                        <?php for ( $i = 1; $i <= 5; $i++ ) : ?>
                                            <li>
                                                <i class="fas fa-star<?php echo ( $i <= $testimonial->stars ) ? '' : '-o'; ?>"></i>
                                            </li>
                                        <?php endfor; ?>
                                    </ul>
                                </div>

                                <div class="text-testimonial">
                                    <?php echo wpautop( $testimonial->content ); ?>
                                </div>

                                <?php if ( ! empty( $link_url ) ) : ?>
                                    <a class="link-testimonial" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>">
                                        Watch Video
                                    </a>
                                <?php endif; ?>

                            </div>    
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>

        </div>
    </div>

</section>
