<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class NewModule extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('Carousel Slider Testimonial', 'fl-builder'),
            'description'     => __('Carousel Slider / SwiperJS', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'star-filled.svg',
        ]);
    }

    public function enqueue_scripts() {
        // Load Swiper from child theme
        wp_enqueue_script(
            'swiper-js',
            get_stylesheet_directory_uri() . '/js/swiper-bundle.min.js',
            [],
            '11.0.0',
            true
        );

        wp_enqueue_style(
            'swiper-css',
            get_stylesheet_directory_uri() . '/css/swiper-bundle.min.css',
            [],
            '11.0.0'
        );

        // Load your module JS (this stays inside module folder)
        wp_enqueue_script(
            'az-circular-init',
            $this->url . 'js/az-carousel-slider-swiper.js',
            ['swiper-js'],
            '1.0.0',
            true
        );
    }
}

// Register module with settings
FLBuilder::register_module('NewModule', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [
                    'testimonials' => [
                        'type'   => 'form',
                        'label'  => __('Testimonials', 'fl-builder'),
                        'form'   => 'testimonial_form',
                        'preview_text' => 'name',
                        'multiple' => true,
                    ],
                ],
            ],
        ],
    ],
]);

// Register the testimonial form
FLBuilder::register_settings_form('testimonial_form', [
    'title' => __('Testimonial', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'title'  => '',
                    'fields' => [
                        'bg_image' => [
                            'type'  => 'photo',
                            'label' => __('Background Image', 'fl-builder'),
                        ],
                        'image' => [
                            'type'  => 'photo',
                            'label' => __('Profile Image', 'fl-builder'),
                        ],
                        'name' => [
                            'type'    => 'text',
                            'label'   => __('Name', 'fl-builder'),
                            'default' => '',
                        ],
                        'link' => [
                            'type'    => 'link',
                            'label'   => __('Link URL', 'fl-builder'),
                        ],
                        'content' => [
                            'type'    => 'editor',
                            'label'   => __('Testimonial Content', 'fl-builder'),
                        ],
                        'stars' => [
                            'type'    => 'select',
                            'label'   => __('Star Rating (1–5)', 'fl-builder'),
                            'options' => [
                                '1' => '1 Star',
                                '2' => '2 Stars',
                                '3' => '3 Stars',
                                '4' => '4 Stars',
                                '5' => '5 Stars',
                            ],
                            'default' => '5',
                        ],
                    ],
                ],
            ],
        ],
    ],
]);

