<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);




?>


<link rel="stylesheet" href="<?php echo esc_url(get_stylesheet_directory_uri() . '/css/jquery.fancybox.min.css'); ?>" />

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-carousel-gallery.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

<?php if (!empty($settings->gallery_images)) : ?>

<!--Carousel Gallery-->
<div class="carousel-gallery">
    <div class="swiper-container">
        <div class="swiper-wrapper">

            <?php foreach ($settings->gallery_images as $image_id) : ?>
                <?php
                $img_url = wp_get_attachment_url($image_id);
                $category = get_post_meta($image_id, 'category', true);
                $caption = get_the_excerpt($image_id);
                ?>
                <?php if ($img_url): ?>
                    <div class="swiper-slide">
                        <a href="<?php echo esc_url($img_url); ?>" data-fancybox="gallery">
                            <div class="image" style="background-image: url(<?php echo esc_url($img_url); ?>)">
                                <div class="overlay">
                                    <i class="fas fa-search-plus"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>    

        </div>
        <div class="swiper-pagination"></div>
    </div>
</div>
<!--#Carousel Gallery-->

<?php endif; ?>

</section>


<script>
jQuery(document).ready(function($) {
  var swiper = new Swiper('.carousel-gallery .swiper-container', {
    effect: 'slide',
    speed: 900,
    slidesPerView: <?php echo (int) $settings->slides_per_view_desktop; ?>,
    loop: <?php echo ($settings->loop === 'true') ? 'true' : 'false'; ?>,
    spaceBetween: <?php echo isset($settings->space_between) ? (int) $settings->space_between : 20; ?>,
    simulateTouch: true,
    autoplay: {
      delay: 5000,
      stopOnLastSlide: false,
      disableOnInteraction: false
    },
    pagination: {
      el: '.carousel-gallery .swiper-pagination',
      clickable: true
    },
    breakpoints: {
  320: {
    slidesPerView: <?php echo (int) $settings->slides_per_view_mobile; ?>,
    spaceBetween: <?php echo isset($settings->space_between) ? (int) $settings->space_between : 10; ?>,
  },
  768: {
    slidesPerView: <?php echo (int) $settings->slides_per_view_tablet; ?>,
    spaceBetween: <?php echo isset($settings->space_between) ? (int) $settings->space_between : 15; ?>,
  },
  1025: {
    slidesPerView: <?php echo (int) $settings->slides_per_view_desktop; ?>,
    spaceBetween: <?php echo isset($settings->space_between) ? (int) $settings->space_between : 20; ?>,
  },
}

  });
});
</script>
