<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Carousel_Gallery extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('Carousel Gallery', 'fl-builder'),
            'description'     => __('Carousel Gallery', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'format-gallery.svg',
        ]);

        // Ensure scripts/styles load properly
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
    }

    public function enqueue_scripts() {
        // Fancybox CSS
        wp_enqueue_style(
            'fancybox',
            get_stylesheet_directory_uri() . '/css/jquery.fancybox.min.css',
            [],
            '3.5.7'
        );
    
        // Swiper CSS
        wp_enqueue_style(
            'swiper',
            get_stylesheet_directory_uri() . '/css/swiper.min.css',
            [],
            '8.4.5'
        );
    
        // Fancybox JS
        wp_enqueue_script(
            'fancybox-js',
            get_stylesheet_directory_uri() . '/js/jquery.fancybox.min.js',
            ['jquery'],
            '3.5.7',
            true
        );
    
        // Swiper JS
        wp_enqueue_script(
            'swiper-js',
            get_stylesheet_directory_uri() . '/js/swiper.min.js',
            [],
            '8.4.5',
            true
        );
    }
    
}
    

// Register the module
FLBuilder::register_module('AZ_Carousel_Gallery', [
    'general' => [
        'title'    => __('Gallery Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Main Settings', 'fl-builder'),
                'fields' => [
    'gallery_images' => [
        'type'        => 'multiple-photos',
        'label'       => __('Select Images', 'fl-builder'),
        'help'        => __('Choose the images to display in the gallery.', 'fl-builder'),
    ],
   'slides_per_view_desktop' => [
    'type'    => 'unit',
    'label'   => __('Desktop Items', 'fl-builder'),
    'default' => '5',
],
'slides_per_view_tablet' => [
    'type'    => 'unit',
    'label'   => __('iPad (Tablet) Items', 'fl-builder'),
    'default' => '3',
],
'slides_per_view_mobile' => [
    'type'    => 'unit',
    'label'   => __('Mobile Items', 'fl-builder'),
    'default' => '1',
],

    'loop' => [
        'type'        => 'select',
        'label'       => __('Enable Looping?', 'fl-builder'),
        'default'     => 'true',
        'options'     => [
            'true'  => __('Yes', 'fl-builder'),
            'false' => __('No', 'fl-builder'),
        ],
        'description' => __('Whether to loop the carousel slides.', 'fl-builder'),
    ],
    'space_between' => [
    'type'        => 'unit',
    'label'       => __('Space Between Slides', 'fl-builder'),
    'default'     => '20',
    'description' => __('Set the space (in px) between each slide. Use 0 for no space.', 'fl-builder'),
],

],

            ],
        ],
    ],
]);
