<?php
/**
 * Shared helper functions for Custom BB Modules
 */

if (!function_exists('az_get_all_post_types')) {
    function az_get_all_post_types() {
        $post_types = get_post_types(['public' => true], 'objects');
        $options = [];

        foreach ($post_types as $slug => $post_type) {
            if ($slug === 'attachment') continue;
            $options[$slug] = $post_type->labels->singular_name;
        }

        asort($options);
        return $options;
    }
}

if (!function_exists('az_get_product_categories')) {
    function az_get_product_categories() {
        if (!class_exists('WooCommerce')) return [];

        $terms = get_terms(['taxonomy' => 'product_cat', 'hide_empty' => false]);
        $options = [];

        if (!is_wp_error($terms)) {
            foreach ($terms as $term) {
                $options[$term->term_id] = $term->name;
            }
        }

        return $options;
    }
}
