<?php
// Add 'Duplicate' link to post/page actions
function bbm_duplicate_post_link($actions, $post) {
    if (current_user_can('edit_posts')) {
        $actions['duplicate'] = '<a href="' . wp_nonce_url(
            admin_url('admin.php?action=bbm_duplicate_post_as_draft&post=' . $post->ID),
            basename(__FILE__),
            'duplicate_nonce'
        ) . '" title="Duplicate this item">Duplicate</a>';
    }
    return $actions;
}
add_filter('post_row_actions', 'bbm_duplicate_post_link', 10, 2);
add_filter('page_row_actions', 'bbm_duplicate_post_link', 10, 2);

// Handle the duplication logic
function bbm_duplicate_post_as_draft() {
    if (
        !isset($_GET['post']) ||
        !isset($_GET['duplicate_nonce']) ||
        !wp_verify_nonce($_GET['duplicate_nonce'], basename(__FILE__))
    ) {
        wp_die('Permission check failed');
    }

    $post_id = absint($_GET['post']);
    $post = get_post($post_id);

    if (!$post) {
        wp_die('Post not found.');
    }

    $new_post = array(
        'post_title'   => $post->post_title . ' (Copy)',
        'post_content' => $post->post_content,
        'post_status'  => 'draft',
        'post_type'    => $post->post_type,
        'post_author'  => get_current_user_id(),
    );

    $new_post_id = wp_insert_post($new_post);

    // Copy all post meta
    $meta = get_post_meta($post_id);
    foreach ($meta as $key => $values) {
        foreach ($values as $value) {
            update_post_meta($new_post_id, $key, maybe_unserialize($value));
        }
    }

    wp_redirect(admin_url('post.php?action=edit&post=' . $new_post_id));
    exit;
}
add_action('admin_action_bbm_duplicate_post_as_draft', 'bbm_duplicate_post_as_draft');
