<?php
/**
 * Plugin Name: Custom AZ BB Modules
 * Description: Custom Beaver Builder modules By Amir.
 * Version: 2.0
 */

function load_custom_bb_modules() {
    if ( class_exists('FLBuilder') ) {
        require_once plugin_dir_path(__FILE__) . 'includes/helpers.php';
        require_once plugin_dir_path(__FILE__) . 'includes/duplicate-post.php';
        require_once plugin_dir_path(__FILE__) . 'includes/reusable-sections.php';
        require_once plugin_dir_path(__FILE__) . 'modules/logo-marquee/logo-marquee.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-post-grid/az-post-grid.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-flip-grid/az-flip-grid.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-post-grid-custom/az-post-grid-custom.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-accordion/az-accordion.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-tabs/az-tabs.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-countdown/az-countdown.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-animation-wave/az-animation-wave.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-map/az-map.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-icon-group/az-icon-group.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-gallery/az-gallery.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-carousel-gallery/az-carousel-gallery.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-post-grid-filtering/az-post-grid-filtering.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-video-gallery/az-video-gallery.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-video-gallery-grid/az-video-gallery-grid.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-list/az-list.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-testimonial-box/az-testimonial-box.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-testimonials-slider/az-testimonials-slider.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-swiper-vertical/az-swiper-vertical.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-circular-slider/az-circular-slider.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-table/az-table.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-image-sphere/az-image-sphere.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-pillar/az-pillar.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-inner-banner/az-inner-banner.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-share-social/az-share-social.php';
        require_once plugin_dir_path(__FILE__) . 'modules/az-swiper/az-swiper.php';
		require_once plugin_dir_path(__FILE__) . 'modules/az-flip-grid-swap/az-flip-grid-swap.php';
		require_once plugin_dir_path(__FILE__) . 'modules/az-carousel-slider-swiper/az-carousel-slider-swiper.php';

    }
}
add_action('init', 'load_custom_bb_modules');


if ( ! function_exists('register_az_shortcodes') ) {
	add_action('init', 'register_az_shortcodes');
	function register_az_shortcodes() {

		// Post Title
		add_shortcode('az_post_title', function() {
			if (is_singular()) {
				return get_the_title();
			}
			return '';
		});

		// Featured Image URL
		add_shortcode('az_post_image_url', function() {
			if (is_singular() && has_post_thumbnail()) {
				return get_the_post_thumbnail_url(get_the_ID(), 'full');
			}
			return '';
		});

		
	}
}


// ACF: Custom Field Description
add_shortcode('az_acf_description', function() {
	if (!function_exists('get_field')) return ''; // ACF not active

	$post_id = get_the_ID();
	if (!$post_id || $post_id === 0) {
		$post_id = get_queried_object_id();
	}
	if (!$post_id) return '';

	$value = get_field('description_post', $post_id);

	if (!$value) return '';

	return wpautop(do_shortcode($value));
});


// Hover-Based Submenu Toggle
function custom_menu_hover_script() {
  ?>
  <script type="text/javascript">
    jQuery(document).ready(function($) {
      $('li.menu-item-has-children').on('mouseenter', function() {
        $(this).addClass('fl-sub-menu-open');
      }).on('mouseleave', function() {
        $(this).removeClass('fl-sub-menu-open');
      });
    });
  </script>
  <?php
}
add_action('wp_footer', 'custom_menu_hover_script');



