<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class NewModule extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('New Module', 'fl-builder'),
            'description'     => __('A clean starter module.', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'star-filled.svg',
        ]);
    }
}

FLBuilder::register_module('NewModule', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Main Section', 'fl-builder'),
                'fields' => [

                    'text_field' => [
                        'type'    => 'text',
                        'label'   => __('Text Field', 'fl-builder'),
                        'default' => 'Sample text',
                    ],

                    'textarea_field' => [
                        'type'    => 'textarea',
                        'label'   => __('Textarea Field', 'fl-builder'),
                        'default' => '',
                    ],

                    'code_field' => [
                        'type'    => 'code',
                        'label'   => __('Code Field', 'fl-builder'),
                        'mode'    => 'html',
                        'default' => '',
                    ],

                    'editor_field' => [
                        'type'    => 'editor',
                        'label'   => __('Editor Field', 'fl-builder'),
                        'default' => '',
                    ],

                    'color_field' => [
                        'type'    => 'color',
                        'label'   => __('Color Field', 'fl-builder'),
                        'default' => '#ff0000',
                    ],

                    'number_field' => [
                        'type'    => 'unit',
                        'label'   => __('Number Field', 'fl-builder'),
                        'default' => '50',
                        'units'   => ['px', 'em', 'rem'],
                    ],

                    'select_field' => [
                        'type'    => 'select',
                        'label'   => __('Select Field', 'fl-builder'),
                        'options' => [
                            'one' => __('One', 'fl-builder'),
                            'two' => __('Two', 'fl-builder'),
                        ],
                        'default' => 'one',
                    ],

                    'multiselect_field' => [
                        'type'         => 'select',
                        'label'        => __('Multi Select Field', 'fl-builder'),
                        'multi-select' => true,
                        'options'      => [
                            'apple'  => __('Apple', 'fl-builder'),
                            'banana' => __('Banana', 'fl-builder'),
                            'cherry' => __('Cherry', 'fl-builder'),
                        ],
                        'default' => [],
                    ],

                    'checkbox_field' => [
                        'type'    => 'checkbox',
                        'label'   => __('Checkbox Field', 'fl-builder'),
                        'default' => 0,
                    ],

                    'checkbox_group_field' => [
                        'type'    => 'checkbox-group',
                        'label'   => __('Checkbox Group', 'fl-builder'),
                        'options' => [
                            'html' => __('HTML', 'fl-builder'),
                            'css'  => __('CSS', 'fl-builder'),
                            'js'   => __('JavaScript', 'fl-builder'),
                        ],
                        'default' => [],
                    ],

                    'radio_field' => [
                        'type'    => 'radio',
                        'label'   => __('Radio Field', 'fl-builder'),
                        'options' => [
                            'yes' => __('Yes', 'fl-builder'),
                            'no'  => __('No', 'fl-builder'),
                        ],
                        'default' => 'yes',
                    ],

                    'photo_field' => [
                        'type'  => 'photo',
                        'label' => __('Photo Field', 'fl-builder'),
                    ],

                    'multiple_photos_field' => [
                        'type'  => 'multiple-photos',
                        'label' => __('Multiple Photos Field', 'fl-builder'),
                    ],

                    'media_field' => [
                        'type'       => 'media',
                        'label'      => __('Media Field', 'fl-builder'),
                        'media_type' => 'video',
                        'preview'    => 'default',
                    ],

                    'formattable_field' => [
                        'type'  => 'formattable',
                        'label' => __('Formattable Field', 'fl-builder'),
                        'preview_text' => 'heading', // Ensures proper preview in builder
                        'rows'  => [
                            'heading' => [
                                'label'   => __('Heading', 'fl-builder'),
                                'type'    => 'text',
                                'default' => '',
                            ],
                            'description' => [
                                'label'   => __('Description', 'fl-builder'),
                                'type'    => 'textarea',
                                'default' => '',
                            ],
                        ],
                    ],

                    'icon_field' => [
                        'type'  => 'icon',
                        'label' => __('Icon Picker', 'fl-builder'),
                    ],
                ],
            ],
        ],
    ],
]);
