<?php
/**
 * Single template for Business Matchmaking (CPT: business-matchmaking)
 */

get_header();

while ( have_posts() ) : the_post();

    $post_id      = get_the_ID();

    // ACF fields
    $email        = sanitize_email( (string) get_field('email', $post_id) );
    $budget_range = (string) get_field('budget_range', $post_id);
    $location     = (string) get_field('location', $post_id);
    $summary      = (string) get_field('short_summary', $post_id);

    // Owner/company (ACF user field 'bm_owner' you already use)
    $owner_id  = (int) get_field('bm_owner', $post_id);
    $company   = $owner_id ? get_user_meta($owner_id, 'company_name', true) : '';
    $ownername = $owner_id ? get_the_author_meta('display_name', $owner_id) : get_the_author();

    if ( ! $company && $owner_id ) {
        $company = $ownername; // fallback
    }

    // Taxonomies
    $industries = get_the_terms( $post_id, 'category-industry' );
    $ptypes     = get_the_terms( $post_id, 'partnership-type' );

    // Featured image
    $thumb = get_the_post_thumbnail_url( $post_id, 'large' );
    ?>

    <main id="primary" class="bm-single container">
        <article <?php post_class('bm-article'); ?>>

            <div class="bm-hero">
                <?php if ( $thumb ) : ?>
                    <div class="bm-hero__media" style="background-image:url('<?php echo esc_url( $thumb ); ?>');"></div>
                <?php endif; ?>

                <div class="bm-hero__content">
                    <h2 class="bm-title"><?php echo esc_html( get_the_title() ); ?></h2>

                    <div class="bm-meta">
                     
                        <?php if ( $industries && ! is_wp_error( $industries ) ) : ?>
                            <?php foreach ( $industries as $t ) : ?>
                                <a class="bm-chip" href="<?php echo esc_url( get_term_link( $t ) ); ?>">
                                    <?php echo esc_html( $t->name ); ?>
                                </a>
                            <?php endforeach; ?>
                        <?php endif; ?>

                        <?php if ( $ptypes && ! is_wp_error( $ptypes ) ) : ?>
                            <?php foreach ( $ptypes as $t ) : ?>
                                <a class="bm-chip bm-chip--alt" href="<?php echo esc_url( get_term_link( $t ) ); ?>">
                                    <?php echo esc_html( $t->name ); ?>
                                </a>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    
                    <div class="bm-summary">
                <?php if ( $summary ) : ?>
                    <p class="lead"><?php echo esc_html( $summary ); ?></p>
                <?php endif; ?>

                <ul class="bm-facts">
                    <?php if ( $location ) : ?>
                        <li><strong>Location:</strong> <?php echo esc_html( $location ); ?></li>
                    <?php endif; ?>

                    <?php if ( $budget_range ) : ?>
                        <li><strong>Budget Range:</strong> <?php echo esc_html( $budget_range ); ?></li>
                    <?php endif; ?>

                    <?php if ( $company ) : ?>
                        <li><strong>Business Owner:</strong> <?php echo esc_html( $company ); ?></li>
                    <?php endif; ?>
                </ul>

                <?php if ( $email ) : ?>
                    <p class="bm-cta">
                        <a class="bm-btn" href="mailto:<?php echo esc_attr( $email ); ?>?subject=<?php echo rawurlencode( 'Regarding: ' . get_the_title() ); ?>">
                            Contact This Business
                        </a>
                    </p>
                <?php endif; ?>
            </div>
                    
                </div>
            </div>

        

            <section class="bm-content">
                <?php
                // Optional long content if you decide to use the WP editor as well
                the_content();
                ?>
            </section>

            <?php
            // Related listings (same industry or partnership type)
            $tax_query = [];
            if ( $industries && ! is_wp_error( $industries ) ) {
                $tax_query[] = [
                    'taxonomy' => 'category-industry',
                    'field'    => 'term_id',
                    'terms'    => wp_list_pluck( $industries, 'term_id' ),
                ];
            }
            if ( $ptypes && ! is_wp_error( $ptypes ) ) {
                $tax_query[] = [
                    'taxonomy' => 'partnership-type',
                    'field'    => 'term_id',
                    'terms'    => wp_list_pluck( $ptypes, 'term_id' ),
                ];
            }
            if ( $tax_query ) {
                $related = new WP_Query( [
                    'post_type'      => 'business-matchmaking',
                    'post__not_in'   => [ $post_id ],
                    'posts_per_page' => 3,
                    'tax_query'      => array_merge( [ 'relation' => 'OR' ], $tax_query ),
                ] );
                if ( $related->have_posts() ) : ?>
                    <section class="bm-related d-none">
                        <h2>Related Opportunities</h2>
                        <div class="bm-related__grid">
                            <?php while ( $related->have_posts() ) : $related->the_post(); ?>
                                <a class="bm-related__item" href="<?php the_permalink(); ?>">
                                    <?php the_post_thumbnail( 'medium' ); ?>
                                    <p><?php the_title(); ?></p>
                                </a>
                            <?php endwhile; ?>
                        </div>
                    </section>
                <?php
                wp_reset_postdata();
                endif;
            }
            ?>
        </article>
    </main>

    <style>
    .bm-hero{display:grid;grid-template-columns:1fr;gap:24px;margin:24px 0}
    .bm-hero__media {
	width: 100%;
	/* padding-top: 42%; */
	background: #f5f7fb center/cover no-repeat;
	border-radius: 16px;
	height: 300px;
}
    .bm-title{margin:0 0 8px}
    .bm-chip{display:inline-block;margin:0 6px 6px 0;padding:.35rem .6rem;border-radius:999px;background:#eef4ff;color:#114;border:1px solid #dbe7ff;font-size:.85rem;text-decoration:none}
    .bm-chip--alt{background:#f5fff5;border-color:#dbf3db}
    .bm-summary .lead{font-size:1.1rem;margin:8px 0 16px}
    .bm-facts{list-style:none;padding:0;margin:0 0 14px}
    .bm-facts li{margin:6px 0}
    .bm-btn{display:inline-block;background:#1273eb;color:#fff;padding:.7rem 1rem;border-radius:8px;text-decoration:none}
    .bm-related__grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:16px}
    .bm-related__item img{width:100%;height:auto;border-radius:12px}
    @media(min-width:900px){.bm-hero {
	grid-template-columns: 5fr 7fr;
	align-items: flex-start;
}}
.bm-article {
	padding: 20px 80px;
}
    </style>

<?php
endwhile;

get_footer();
