// Add scroll direction to body
document.addEventListener('DOMContentLoaded', function () {
    let lastScrollTop = 0;
    const body = document.body;
    const offset = 50; // distance from top to consider "near top"
    const nearBottomOffset = 100; // distance from bottom to consider "near bottom"

    window.addEventListener('scroll', function () {
        const st = window.pageYOffset || document.documentElement.scrollTop;
        const docHeight = document.documentElement.scrollHeight;
        const winHeight = window.innerHeight;

        // Direction classes
        if (st > lastScrollTop) {
            body.classList.add('scrolling-down');
            body.classList.remove('scrolling-up');
        } else {
            body.classList.add('scrolling-up');
            body.classList.remove('scrolling-down');
        }

        // Near top
        if (st <= offset) {
            body.classList.add('near-top');
            body.classList.remove('scrolling-up'); // Remove scrolling-up when near top
        } else {
            body.classList.remove('near-top');
        }

        // Near bottom
        if (st + winHeight >= docHeight - nearBottomOffset) {
            body.classList.add('near-bottom');
        } else {
            body.classList.remove('near-bottom');
        }

        lastScrollTop = st <= 0 ? 0 : st; // For mobile bounce
    });
});





// auto-check the correct radio with a tiny script add to that registration page
document.addEventListener('DOMContentLoaded', function(){
  const params = new URLSearchParams(location.search);
  const m = params.get('membership'); // silver|gold|platinum
  const map = {
    silver:   'um_silver-partner',
    gold:     'um_gold-partner',
    platinum: 'um_platinum-partner'
  };
  if (m && map[m]) {
    const sel = document.querySelector('input[name="role"][value="'+map[m]+'"]');
    if (sel) { sel.checked = true; sel.dispatchEvent(new Event('change')); }
  }
});









