<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);

// Category Industry
$industries = get_the_terms(get_the_ID(), 'category-industry');
if ( $industries && !is_wp_error($industries) ) {
  echo '<span class="bm-tax bm-industry">'.esc_html( join(', ', wp_list_pluck($industries, 'name')) ).'</span>';
}

// Partnership Type
$ptypes = get_the_terms(get_the_ID(), 'partnership-type');
if ( $ptypes && !is_wp_error($ptypes) ) {
  echo ' • <span class="bm-tax bm-ptype">'.esc_html( join(', ', wp_list_pluck($ptypes, 'name')) ).'</span>';
}



?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/new-module.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">

         <div class="fl-new-module">

<form method="get" class="bm-filters">
  <label>Industry:
    <select name="industry">
      <option value="">All</option>
      <?php foreach ( get_terms(['taxonomy'=>'category-industry','hide_empty'=>false]) as $t ) : ?>
        <option value="<?php echo esc_attr($t->slug); ?>" <?php selected($_GET['industry'] ?? '', $t->slug); ?>>
          <?php echo esc_html($t->name); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </label>

  <label>Partnership Type:
    <select name="ptype">
      <option value="">All</option>
      <?php foreach ( get_terms(['taxonomy'=>'partnership-type','hide_empty'=>false]) as $t ) : ?>
        <option value="<?php echo esc_attr($t->slug); ?>" <?php selected($_GET['ptype'] ?? '', $t->slug); ?>>
          <?php echo esc_html($t->name); ?>
        </option>
      <?php endforeach; ?>
    </select>
  </label>

  <button type="submit">Filter</button>
</form>

</section>


<script  src="<?php echo esc_url($module->url . 'js/new-module.js'); ?>"></script>   