<?php

if ( ! class_exists( 'FLBuilderModule' ) ) {
    return;
}

class AZ_Testimonials_Slider extends FLBuilderModule {
    public function __construct() {
        parent::__construct([
            'name'            => __('AZ Testimonial Slider', 'fl-builder'),
            'description'     => __('Testimonials Slider', 'fl-builder'),
            'category'        => __('Custom Modules', 'fl-builder'),
            'dir'             => plugin_dir_path(__FILE__),
            'url'             => plugin_dir_url(__FILE__),
            'editor_export'   => true,
            'enabled'         => true,
            'icon'            => 'format-quote.svg',
        ]);
    }
}

FLBuilder::register_settings_form('az_testimonial_item_form', [
    'title' => __('Testimonial Item', 'fl-builder'),
    'tabs'  => [
        'general' => [
            'title'    => __('General', 'fl-builder'),
            'sections' => [
                'main' => [
                    'fields' => [
                        'name' => [
                            'type'  => 'text',
                            'label' => __('Name', 'fl-builder'),
                        ],
                        'description' => [
                            'type'          => 'editor',
                            'label'         => __('Description', 'fl-builder'),
                            'media_buttons' => true,
                            'wpautop'       => true,
                        ],
                        'photo' => [
                            'type'  => 'photo',
                            'label' => __('Photo', 'fl-builder'),
                        ],
                    ]
                ]
            ]
        ]
    ]
]);



FLBuilder::register_module('AZ_Testimonials_Slider', [
    'general' => [
        'title'    => __('General Settings', 'fl-builder'),
        'sections' => [
            'main' => [
                'title'  => __('Testimonials', 'fl-builder'),
                'fields' => [

                    // SLIDER TESTIMONIALS
                    'testimonials' => [
                        'type'         => 'form',
                        'label'        => __('Testimonials', 'fl-builder'),
                        'form'         => 'az_testimonial_item_form',
                        'preview_text' => 'name',
                        'multiple'     => true,
                    ],

                    // NEW FIELDS
                    'nav_icon_left' => [
    'type'  => 'icon',
    'label' => __('Left Arrow Icon', 'fl-builder'),
    'default' => 'fa fa-chevron-left',
],
'nav_icon_right' => [
    'type'  => 'icon',
    'label' => __('Right Arrow Icon', 'fl-builder'),
    'default' => 'fa fa-chevron-right',
],
'nav_color' => [
    'type'        => 'color',
    'label'       => __('Arrow & Bullet Color', 'fl-builder'),
    'default'     => '#333333',
    'show_reset'  => true,
],
'nav_hover_color' => [
    'type'        => 'color',
    'label'       => __('Arrow & Bullet Hover Color', 'fl-builder'),
    'default'     => '#1d9fd9',
    'show_reset'  => true,
],

                ],
            ],
        ],
    ],
]);


