<?php
$settings    = $module->settings;
$tabs        = $settings->tabs ?? [];
$module_id   = 'az-tabs-' . $module->node;
?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-tabs.css'); ?>" />

<div id="<?php echo esc_attr($module_id); ?>" class="az-tabs-wrapper">
	<ul class="nav nav-tabs" role="tablist">
		<?php foreach ($tabs as $i => $tab): ?>
			<li class="nav-item" role="presentation">
				<button class="nav-link <?php echo $i === 0 ? 'active' : ''; ?>" 
						id="tab-<?php echo $i; ?>-tab" 
						data-bs-toggle="tab" 
						data-bs-target="#tab-<?php echo $i; ?>" 
						type="button" 
						role="tab">
					<?php echo esc_html($tab->title); ?>
				</button>
			</li>
		<?php endforeach; ?>
	</ul>

	<div class="tab-content">
		<?php foreach ($tabs as $i => $tab): ?>
			<div class="tab-pane fade <?php echo $i === 0 ? 'show active' : ''; ?>" 
				 id="tab-<?php echo $i; ?>" 
				 role="tabpanel">
				<?php echo apply_filters('the_content', $tab->content); ?>
			</div>
		<?php endforeach; ?>
	</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
