<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<link rel="stylesheet" href="<?php echo esc_url($module->url . 'css/az-table.css'); ?>" />

<section id="module-<?php echo esc_attr($module->slug); ?>"
         class="<?php echo esc_attr($module->slug); ?>"
         data-module="<?php echo esc_attr($module_slug); ?>">


			<div class="table-view">

				<!-- Table Filter -->

				<div id="filter" class="filter">
					<div id="filter-search" class="filter-search">
						<input type="text" name="search" placeholder="Search">
						<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/search.svg" alt="Search">
					</div>

					<div class="filter__controls">
						<div class="filter-selection">
							<div class="filter-selection__label">Status</div>

							<div id="filter-select" class="filter-select">
								<input readonly type="text" name="status" value="All">
								<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/select.svg" alt="Search">

								<ul class="filter-select__options">
									<li tabindex="0" data-option class="selected">All</li>
									<li tabindex="0" data-option>Success</li>
									<li tabindex="0" data-option>Pending</li>
									<li tabindex="0" data-option>Rejected</li>
								</ul>
							</div>
						</div>

						<a title="Export JSON" href="https://bato-web-agency.github.io/bato-shared/table-view/assets/data.json" target="_blank" class="filter-export">
							<span>JSON</span>
							<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/export.svg" alt="Export JSON">
						</a>
					</div>
				</div>

				<div id="table" class="table">
					<div data-simplebar data-simplebar-auto-hide="false" class="table__inner">
						<div class="table__scroll">
							<!-- Table Head -->

							<div id="head" class="table__head">
								<div class="table__tr">
									<div class="table__td table__th fixed">
										<div data-control="checkbox" data-select="all" class="table-checkbox">
											<label title="Select all rows" tabindex="0">
												<input hidden type="checkbox">
											</label>
										</div>
									</div>
									<div class="table__td table__th link fixed">
										<div title="Sort" tabindex="0" data-control="invoice" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Invoice ID</span>
										</div>
									</div>
									<div class="table__td table__th contact">
										<div title="Sort" tabindex="0" data-control="contact" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Initiator</span>
										</div>
									</div>
									<div class="table__td table__th">
										<div title="Sort" tabindex="0" data-control="company" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Company</span>
										</div>
									</div>
									<div class="table__td table__th progress">
										<div title="Sort" tabindex="0" data-control="progress" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Completion</span>
										</div>
									</div>
									<div class="table__td table__th">
										<div class="table-control">
											<span>Details</span>
										</div>
									</div>
									<div class="table__td table__th datetime">
										<div title="Sort" tabindex="0" data-control="datetime" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Invoice Date</span>
										</div>
									</div>
									<div class="table__td table__th status">
										<div title="Sort" tabindex="0" data-control="status" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Status</span>
										</div>
									</div>
									<div class="table__td table__th amount fixed">
										<div title="Sort" tabindex="0" data-control="amount" data-sort="desc" class="table-control">
											<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/sort.svg" alt="Sort">
											<span>Amount</span>
										</div>
									</div>
								</div>
							</div>

							<!-- Table Body: generated -->

							<div id="body" class="table__body"></div>
						</div>
					</div>

					<!-- Table Footer -->

					<div class="table__footer">
						<div class="table-counter">
							<span class="table-counter__label">Showing</span>
							<span data-limit>0</span>/<span data-total>0</span>
						</div>

						<div title="Load more" tabindex="0" class="load-more" data-load-more>
							<span>Load more</span>
							<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/arrow-down.svg" alt="Load more">
						</div>

						<div class="table-counter"></div> <!-- positioning fix -->
					</div>

					<!-- Nothing Found template -->

					<template id="empty">
						<div class="table-empty">
							<img src="https://bato-web-agency.github.io/bato-shared/table-view/img/empty.svg" alt="Empty">
							<div class="table-empty__data">
								<div class="table-empty__title">Nothing was found for your request.</div>
								<div class="table-empty__text">Expand your search parameters.</div>
							</div>
						</div>
					</template>
				</div>

			</div>
 

</section>


<script  src="<?php echo esc_url($module->url . 'js/az-table.js'); ?>"></script>

<script src='https://cdn.jsdelivr.net/npm/simplebar@latest/dist/simplebar.min.js'></script>
