<?php
$settings     = $module->settings;
$module_slug  = sanitize_html_class($module->slug);
?>

<!-- Swiper Styles -->
<link rel="stylesheet" href="<?php echo esc_url( $module->url . 'css/az-swiper.css' ); ?>" />
<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/swiper-bundle.min.css" />

<section id="module-<?php echo esc_attr( $module->slug ); ?>"
         class="<?php echo esc_attr( $module->slug ); ?>"
         data-module="<?php echo esc_attr( $module_slug ); ?>">


<?php if (!empty($settings->nav_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-right,
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-left,
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet {
      color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
    #module-<?php echo esc_attr($module->slug); ?> .swiper-pagination-bullet-active {
      background-color: #<?php echo esc_attr($settings->nav_color); ?>;
    }
  </style>
<?php endif; ?>

<?php if (!empty($settings->nav_hover_color)) : ?>
  <style>
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-right:hover,
    #module-<?php echo esc_attr($module->slug); ?> .fa-chevron-left:hover {
      color: #<?php echo esc_attr($settings->nav_hover_color); ?>;
    }
  </style>
<?php endif; ?>


<?php if ( ! empty( $settings->manual_testimonials ) ) : ?>
<?php
  $slides_desktop = max(1, intval($settings->slides_desktop ?? 5));
  $slides_tablet  = max(1, intval($settings->slides_tablet  ?? 3));
  $slides_mobile  = max(1, intval($settings->slides_mobile  ?? 2));
?>

<div class="az-swiper-wrapper"
     data-nav-color="<?php echo esc_attr( $settings->nav_color ); ?>"
     data-nav-hover-color="<?php echo esc_attr( $settings->nav_hover_color ); ?>"
     data-slides-desktop="<?php echo esc_attr( $slides_desktop ); ?>"
     data-slides-tablet="<?php echo esc_attr( $slides_tablet ); ?>"
     data-slides-mobile="<?php echo esc_attr( $slides_mobile ); ?>"
     style="background-color: <?php echo esc_attr( $settings->bg_color ); ?>;">


    <!-- Swiper Container -->
    <div class="swiper az-swiper mySwiper-<?php echo esc_attr( $module->node ); ?>">


        <!-- Slides Wrapper -->
        <div class="swiper-wrapper">
            <?php foreach ( $settings->manual_testimonials as $testimonial ) : ?>
                <div class="swiper-slide az-swiper-slide">
                    <div class="flex">

                    <?php
                    $is_image = isset( $testimonial->media_type ) && $testimonial->media_type === 'image';
                    $is_icon  = isset( $testimonial->media_type ) && $testimonial->media_type === 'icon';
                    ?>
                    <div class="icon" style="background-image: url('<?php echo esc_url( wp_get_attachment_url( $testimonial->photo ) ); ?>');">
                    <?php if ( $is_image && ! empty( $testimonial->photo ) ) : ?>
                    </div>
                    <?php elseif ( $is_icon && ! empty( $testimonial->icon ) ) : ?>
                        <i class="az-swiper-icon <?php echo esc_attr( $testimonial->icon ); ?>"></i>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->name ) ) : ?>
                        <h3 class="az-swiper-title"><?php echo esc_html( $testimonial->name ); ?></h3>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->description ) ) : ?>
                        <div class="az-swiper-description"><?php echo wp_kses_post( $testimonial->description ); ?></div>
                    <?php endif; ?>

                    <?php if ( ! empty( $testimonial->link_url ) ) : ?>
                        <p><a href="<?php echo esc_url( $testimonial->link_url ); ?>"
                              target="_blank" class="az-swiper-link">Read more</a></p>
                    <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

        
    </div>

    <!-- Swiper Navigation & Pagination -->
        <div class="swiper-pagination az-swiper-pagination"></div>
<div class="swiper-button-prev az-swiper-prev">
    <i class="<?php echo esc_attr( $settings->nav_icon_left ); ?>"></i>
</div>
<div class="swiper-button-next az-swiper-next">
    <i class="<?php echo esc_attr( $settings->nav_icon_right ); ?>"></i>
</div>
<div class="swiper-scrollbar az-swiper-scrollbar d-none"></div>

</div>
<?php endif; ?>

</section>

<!-- Swiper JS -->
<script src="<?php echo get_stylesheet_directory_uri(); ?>/js/swiper-bundle.min.js"></script>

<!-- Swiper Initialization -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    // Scope to this module instance
    var moduleRoot = document.getElementById('module-<?php echo esc_js( $module->slug ); ?>');
    if (!moduleRoot) return;

    var wrapper = moduleRoot.querySelector('.az-swiper-wrapper');
    if (!wrapper) return;

    // Pull per-device values with sane fallbacks
    var slidesDesktop = parseInt(wrapper.getAttribute('data-slides-desktop'), 10) || 5;
    var slidesTablet  = parseInt(wrapper.getAttribute('data-slides-tablet'), 10)  || 3;
    var slidesMobile  = parseInt(wrapper.getAttribute('data-slides-mobile'), 10)  || 2;

    // Get the right elements inside this module only
    var swiperEl      = moduleRoot.querySelector('.mySwiper-<?php echo esc_js( $module->node ); ?>');
    var nextBtn       = moduleRoot.querySelector('.az-swiper-next');
    var prevBtn       = moduleRoot.querySelector('.az-swiper-prev');
    var paginationEl  = moduleRoot.querySelector('.az-swiper-pagination');
    var scrollbarEl   = moduleRoot.querySelector('.az-swiper-scrollbar');

    if (!swiperEl) return;

    var swiper = new Swiper(swiperEl, {
      slidesPerView: slidesDesktop, // default; breakpoints override below
      spaceBetween: 30,
      freeMode: true,
      autoplay: {
        delay: 3000,
        disableOnInteraction: false
      },
      navigation: {
        nextEl: nextBtn,
        prevEl: prevBtn
      },
      pagination: {
        el: paginationEl,
        clickable: true
      },
      scrollbar: {
        el: scrollbarEl,
        draggable: true
      },
      breakpoints: {
        0: {
          slidesPerView: slidesMobile
        },
        768: {
          slidesPerView: slidesTablet
        },
        1024: {
          slidesPerView: slidesDesktop
        }
      }
    });
  });
</script>

